<?php
/* inicialização das rotinas  */
include_once('autoload.php');
$pdo = new verificar('users','login.php');
$ut  = new Util();

require_once('includes/infos.php');

try {

  if($ut->modo()=='POST' && isset($_GET['ac']) && $_GET['ac']=='user'){
    
    $ins = $pdo->prep("INSERT INTO users SET us_nome=?, us_login=?, us_senha=?, us_email=?");

    $ins->bindValue(1, $_POST['nome'], PDO::PARAM_STR);
    $ins->bindValue(2, $_POST['login'], PDO::PARAM_STR);
    $ins->bindValue(3, password_hash($_POST['pass'], PASSWORD_DEFAULT) );
    $ins->bindValue(4, $_POST['email'], PDO::PARAM_STR);

    $ins->execute();
    header('Location: '.$_SERVER['PHP_SELF']);

  }

}catch(Exception $e){
   $erro = $e->getMessage();
}
?>
<!doctype html>
<html lang="pt-BR">
<head>
<meta charset="utf-8">
<title>Dashboard</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<!-- Descrição -->
<meta name="description" content="">
<!-- Author -->
<meta name="author" content="Alaerte Gabriel">
<!-- COnfiguração de resolução -->
<meta name="viewport" content="width=device-width; initial-scale=1.0">

<!-- Bibliotecas -->
<link rel="stylesheet" href="css/bootstrap.min.css" />
<link rel="stylesheet" href="css/font-awesome.min.css" />
<link href="css/layout.css" rel="stylesheet" type="text/css">
<script src="js/jquery-2.1.3.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script>
$(document).ready(function() {

$('#load').hide();

$(".delete").click(function() {

   $('#load').fadeIn();
   var id = $(this).attr("id");
   var commentContainer = $("#tr_"+id);
	
   $.ajax({
	  
	  type: "POST",
	  url: "controller.php?ac=deluser",
	  data: { reg : id },
	  cache: false,
	  success: function(){
		  commentContainer.slideUp('slow', function() {
        $(this).remove();
      });
		    $('#load').fadeOut();
	   }
   
   });
   return false;

});

});
</script>
</head>
<body>
<div class="container-fluid">
<header>
    	<nav class="navbar navbar-inverse navbar-fixed-top">
 		<div class="container-fluid">
    <!-- Brand and toggle get grouped for better mobile display -->
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#menu1" aria-expanded="false">
        <span class="sr-only"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <a class="navbar-brand" href="#">
      <small>Sistema verificador</small>
      </a>
    </div>

    <!-- Collect the nav links, forms, and other content for toggling -->
    <div class="collapse navbar-collapse" id="menu1">
      <ul class="nav navbar-nav">
        <li class="active"><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
      </ul>
      <ul class="nav navbar-nav navbar-right">
        <li class="dropdown">
          <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
          <i class="glyphicon glyphicon-user"></i> <?=$pdo->Logado()?> <span class="caret"></span>
          </a>
          <ul class="dropdown-menu">
            <li><a href="#!" data-toggle="modal" data-target="#modal1"><i class="fa fa-cog"></i> Alterar Senha</a></li>
            <li role="separator" class="divider"></li>
            <li><a href="sair.php"><i class="glyphicon glyphicon-log-out"></i> Logout</a></li>
          </ul>
    </div><!-- /.navbar-collapse -->
  </div><!-- /.container-fluid -->
</nav>
</header>
<main>
	<div class="row">
    	<div class="col-md-2">
        <p class="text-center"><img src="images/user-group.png"></p>
        <hr>
        
        <ul class="nav nav-pills nav-stacked">
        	<li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        	<li><a href="servidor.php"><i class="fa fa-plus"></i> Cadastrar Servidor</a></li>
          <li><a href="#!" data-toggle="modal" data-target="#modalIP"><i class="fa fa-ban"></i> Bloquear IP</a></li>
          <li class="active"><a href="user.php"><i class="fa fa-user"></i> Operadores</a></li>
          <li><a href="sair.php"><i class="fa fa-sign-out"></i> Sair</a></li>
        </ul>
      </div>
      <div class="col-md-10">
        	<div class="row">
            <h1 class="titulosistema">Sistema Verificador <i class="fa fa-eye"></i></h1>
        	  <div class="col-md-3">
            	<div class="blocos">
                	<h4>Total de IPs</h4>
					         <h3><i class="fa fa-eye"></i> <?=$TotalIP?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Operadores</h4>
					        <h3><i class="fa fa-users"></i> <?=$TotalUSER?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Servidores</h4>
					         <h3><i class="fa fa-server"></i> <?=$TotalSERV?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Verificação</h4>
					         <h3><i class="fa fa-comments"></i> Ativa</h3>
              </div>
            </div>
          </div>
          <p>&nbsp;</p>
            <div class="row">
            	<div class="col-md-12">
                  <?php
                  isset($erro) ? print '<div class="alert alert-danger">ATENÇÃO: '.$erro.'</div>' : false;
                  ?>
                	<div class="panel panel-info">
                        <div class="panel-heading">
                            <i class="fa fa-server"></i> Servidores
                            <a href="#!" data-toggle="modal" data-target="#modal2" class="btn btn-xs btn-success pull-right"><i class="fa fa-plus"></i> Adicionar</a>
                        </div>
                        <div class="panel-body">
                            <div id="load" align="center">
                            <img src="images/3d_8.gif" width="28" height="28" align="absmiddle"/> Loading...
                            </div>
                            <table class="table table-hover table-striped">
                            	<thead>
                                	<tr>
                                      <th>Nome</th>
                                		  <th>Login</th>
                                      <th>Email</th>
                                      <th>Ação</th>
                                    </tr>
                                </thead>
                                <tbody>
                                	<?php
                                  $dados = $pdo->exe("SELECT * FROM users");
                                  if($dados->rowCount() > 0){
                                    while($lista = $dados->fetch(PDO::FETCH_OBJ)){
                                  ?> 
                                  <tr id="tr_<?=$lista->us_id?>">
                                    <td><?=$lista->us_nome?></td>
                                    <td><?=$lista->us_login?></td>
                                    <td><?=(empty($lista->us_email)) ? 'Não informado' : $lista->us_email?></td>
                                    <td><button id="<?=$lista->us_id?>" class="delete btn btn-xs btn-danger" title="Excluir"><i class="fa fa-trash"></i></button></td>
                                  </tr>
                                  <?php
                                    }
                                  }
                                  ?>
                                </tbody>
                            </table> 
                                                  
                        </div>
                      </div>
                </div>
            </div>
      </div><!--/COL 10 -->
  </div><!--/ROW  -->
</main>
<footer>
<hr>
<div class="text-center">
<p>Copyright &copy; <?=date('Y');?> - Todos os Direitos Reservados</p>
<p><a href="http://www.desite.com.br" target="_blank">
<img src="images/desite-logo-dashboard.png" width="41" height="19" /> Soluções em sistemas Web</a>
</div>

</footer>

</div><!--/ FIM DA CONTAINER FLUID -->

<!-- INICIO DO MODAL ************************* -->
<div class="modal fade" id="modal1" tabindex="-1" role="dialog" aria-labelledby="modal1">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <form name="senhaAlt" id="senhaAlt" method="post" action="index.php?ac=altsenha">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Alteração de Senha de Acesso</h4>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <label>Senha Atual:</label>
            <input type="password" name="senha1" id="senha1" maxlength="12" required="required" class="form-control" placeholder="Digite sua senha atual">
          </div>
          <div class="col-md-6">
            <label>Senha Nova:</label>
            <input type="password" name="senha2" id="senha2" maxlength="12" required="required" class="form-control" placeholder="Digite sua nova senhha.">
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
        <button type="submit" class="btn btn-primary">Alterar</button>
      </div>
    </form>
    </div>
  </div>
</div><!--FINAL MODAL *********************8 -->

<!-- INICIO DO MODAL ************************* -->
<div class="modal fade" id="modal2" tabindex="-1" role="dialog" aria-labelledby="modal2">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <form name="user" id="user" method="post" action="<?=$_SERVER['PHP_SELF']?>?ac=user">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Adicionar novo Usuário ao sistema</h4>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <label>Nome:</label>
            <input type="text" name="nome" id="nome" placeholder="Nome" class="form-control">
          </div>
          <div class="col-md-6">
            <label>Login:</label>
            <input type="text" name="login" id="login" class="form-control" required="required">
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <label>Senha:</label>
            <input type="password" name="pass" id="pass" maxlength="12" class="form-control" required="required">
          </div>
          <div class="col-md-6">
            <label>Email:</label>
            <input type="email" name="email" id="email" placeholder="exemplo@dominio.com" class="form-control" required="required">
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
        <button type="submit" class="btn btn-primary">Adicionar</button>
      </div>
      </form>
    </div>
  </div>
</div><!--FINAL MODAL *********************8 -->

<?php require_once('includes/modals.php'); ?>

</body>
</html>