<?php
/* inicialização das rotinas  */
include_once('autoload.php');
$pdo = new verificar('users','login.php');
$ut = new Util();
$lista = new listanegra();

require_once('includes/infos.php');

try {

  if($ut->modo()=='POST' && isset($_POST['ip']) && !empty($_POST['ip'])){
    
    $ins = $pdo->prep("INSERT INTO listanegra SET li_user=:user, li_ip=:ip, li_ocorrencia=:num, li_profile=:prof, li_block=:bl");
    $ins->bindValue(':ip', $_POST['ip']);
    $ins->bindValue(':num', 4,PDO::PARAM_INT);
    $ins->bindValue(':bl', 1, PDO::PARAM_INT);
    $ins->bindValue(':user',  $_POST['user']);
    $ins->bindValue(':prof',  $_POST['prof']);
    $ins->execute();

    $lista->addLista($pdo, $_POST['ip']);

    header('Location: '.$_SERVER['PHP_SELF']);

  }elseif($ut->modo()=='POST' && isset($_POST['ip']) && empty($_POST['ip'])){
    
    throw new Exception("É obrigatório o preenchimento do campo IP.", 1);

  }elseif($ut->modo()=='POST' && isset($_POST['senha1']) && !empty($_POST['senha1']) && !empty($_POST['senha2'])){

    if(password_verify($_POST['senha1'], $_SESSION['ACP']['senha'])){
      $ins = $pdo->prep("UPDATE users SET us_senha=:password");
      $ins->bindValue(':password', password_hash($_POST['senha2'],PASSWORD_DEFAULT) );
      $ins->execute();
      header('Location: '.$_SERVER['PHP_SELF']);
    }else{
      throw new Exception("Senha Atual incorreta", 1);
    }

  }elseif($ut->modo()=='POST' && (empty($_POST['senha1'])) ){
    throw new Exception("Informe a senha atual bem como a nova senha.", 1);
  }

}catch(Exception $e){
   $erro = $e->getMessage();
}
?>
<!doctype html>
<html lang="pt-BR">
<head>
<meta charset="utf-8">
<title>Dashboard</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<!-- Descrição -->
<meta name="description" content="">
<!-- Author -->
<meta name="author" content="Alaerte Gabriel">
<!-- COnfiguração de resolução -->
<meta name="viewport" content="width=device-width; initial-scale=1.0">

<!-- Bibliotecas -->
<link rel="stylesheet" href="css/bootstrap.min.css" />
<link rel="stylesheet" href="css/font-awesome.min.css" />
<link href="css/layout.css" rel="stylesheet" type="text/css">
<script src="js/jquery-2.1.3.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script>
$(document).ready(function() {

$('#load').hide();

$(".delete").click(function() {

   $('#load').fadeIn();
   var id = $(this).attr("id");
   var commentContainer = $("#tr_"+id);
	
   $.ajax({
	  
	  type: "POST",
	  url: "controller.php?ac=del",
	  data: { reg : id },
	  cache: false,
	  success: function(){
		  commentContainer.slideUp('slow', function() {
        $(this).remove();
      });
		    $('#load').fadeOut();
	   }
   
   });
   return false;

});

});
</script>
</head>
<body>
<div class="container-fluid">
<header>
    	<nav class="navbar navbar-inverse navbar-fixed-top">
 		<div class="container-fluid">
    <!-- Brand and toggle get grouped for better mobile display -->
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#menu1" aria-expanded="false">
        <span class="sr-only"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <a class="navbar-brand" href="#">
      <small>Sistema verificador</small>
      </a>
    </div>

    <!-- Collect the nav links, forms, and other content for toggling -->
    <div class="collapse navbar-collapse" id="menu1">
      <ul class="nav navbar-nav">
        <li class="active"><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
      </ul>
      <ul class="nav navbar-nav navbar-right">
        <li class="dropdown">
          <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
          <i class="glyphicon glyphicon-user"></i> <?=$pdo->Logado()?> <span class="caret"></span>
          </a>
          <ul class="dropdown-menu">
            <li><a href="#!" data-toggle="modal" data-target="#modal1"><i class="fa fa-cog"></i> Alterar Senha</a></li>
            <li role="separator" class="divider"></li>
            <li><a href="sair.php"><i class="glyphicon glyphicon-log-out"></i> Logout</a></li>
          </ul>
    </div><!-- /.navbar-collapse -->
  </div><!-- /.container-fluid -->
</nav>
</header>
<main>
	<div class="row">
    	<div class="col-md-2">
        <p class="text-center"><img src="images/user-group.png"></p>
        <hr>
        
        <ul class="nav nav-pills nav-stacked">
        	<li class="active"><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        	<li><a href="servidor.php"><i class="fa fa-plus"></i> Cadastrar Servidor</a></li>
          <li><a href="#!" data-toggle="modal" data-target="#modalIP"><i class="fa fa-ban"></i> Bloquear IP</a></li>
          <li><a href="user.php"><i class="fa fa-user"></i> Operadores</a></li>
          <li><a href="estatistica.php"><i class="fa fa-bar-chart"></i> Estatísticas</a></li>
          <li><a href="sair.php"><i class="fa fa-sign-out"></i> Sair</a></li>
        </ul>
      </div>
      <div class="col-md-10">
        	<div class="row">
            <h1 class="titulosistema">Sistema Verificador <i class="fa fa-eye"></i></h1>
        	  <div class="col-md-3">
            	<div class="blocos">
                	<h4>Total de IPs</h4>
					         <h3><i class="fa fa-eye"></i> <?=$TotalIP?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Operadores</h4>
					        <h3><i class="fa fa-users"></i> <?=$TotalUSER?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Servidores</h4>
					         <h3><i class="fa fa-server"></i> <?=$TotalSERV?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Verificação</h4>
					         <h3><i class="fa fa-comments"></i> Ativa</h3>
              </div>
            </div>
          </div>
          <p>&nbsp;</p>
            <div class="row">
            	<div class="col-md-12">
                  <?php
                  isset($erro) ? print '<div class="alert alert-danger">ATENÇÃO: '.$erro.'</div>' : false;
                  ?>
                	<div class="panel panel-info">
                        <div class="panel-heading">
                            <i class="fa fa-eye"></i> IP Na lista Negra
                            <a href="#!" data-toggle="modal" data-target="#modalIP" class="btn btn-xs btn-success pull-right"><i class="fa fa-plus"></i> Adicionar</a>
                        </div>
                        <div class="panel-body">
                            <div id="load" align="center">
                            <img src="images/3d_8.gif" width="28" height="28" align="absmiddle"/> Loading...
                            </div>
                            <table class="table table-hover table-striped">
                            	<thead>
                                	<tr>
                                		  <th>IP</th>
                                      <th>User</th>
                                		  <th>Data</th>
                                      <th>Nº Ocorrência</th>
                                      <th>Situação</th>
                                      <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                	<?php
                                  $dados = $pdo->exe("SELECT *,date_format(li_data,'%d/%m/%Y - %H:%i') AS data FROM listanegra");
                                  if($dados->rowCount() > 0){
                                    while($lista = $dados->fetch(PDO::FETCH_OBJ)){
                                  ?> 
                                  <tr id="tr_<?=$lista->li_id?>">
                                  	<td><?=$lista->li_ip?></td>
                                    <td><?=$lista->li_user?></td>
                                    <td><?=$lista->data?></td>
                                    <td><?=$lista->li_ocorrencia?></td>
                                    <td><?=($lista->li_ocorrencia > 3) ? '<span class="label label-danger">Bloqueado</span>' : '<span class="label label-warning">Suspeito</span>' ?></td>
                                    <td><button id="<?=$lista->li_id?>" class="delete btn btn-xs btn-danger" title="Excluir"><i class="fa fa-trash"></i></button></td>
                                  </tr>
                                  <?php
                                    }
                                  }
                                  ?>
                                </tbody>
                            </table> 
                                                  
                        </div>
                      </div>
                </div>
            </div>
      </div><!--/COL 10 -->
  </div><!--/ROW  -->
</main>
<footer>
<hr>
<div class="text-center">
<p>Copyright &copy; <?=date('Y');?> - Todos os Direitos Reservados</p>
<p><a href="http://www.desite.com.br" target="_blank">
<img src="images/desite-logo-dashboard.png" width="41" height="19" /> Soluções em sistemas Web</a>
</div>

</footer>

</div><!--/ FIM DA CONTAINER FLUID -->

<?php require_once('includes/modals.php'); ?>

</body>
</html>