<?php
/* inicialização das rotinas  */
include_once('autoload.php');
$pdo = new verificar('users','login.php');
$ut = new Util();
require_once('includes/infos.php'); 

$serv = $pdo->exe("SELECT * FROM servidores WHERE serv_ip <> '' AND serv_porta <> '' AND serv_status=1");
if($serv->rowCount() > 0){

  $result = $serv->fetchAll(PDO::FETCH_OBJ);
  
  foreach( $result AS $dados ){

    $url = $dados->serv_protocolo.'://'.$dados->serv_ip.':'.$dados->serv_porta."/xmlHandler?command=proxy-status";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_USERPWD, $dados->serv_user.':'.$dados->serv_pass);
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_UNRESTRICTED_AUTH, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30); // TIME OUT is 5 seconds
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    $csps[$dados->serv_nome] = $response;
  }
}
?>
<!doctype html>
<html lang="pt-BR">
<head>
<meta charset="utf-8">
<title>Dashboard</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<!-- Descrição -->
<meta name="description" content="">
<!-- Author -->
<meta name="author" content="Alaerte Gabriel">
<!-- COnfiguração de resolução -->
<meta name="viewport" content="width=device-width; initial-scale=1.0">

<!-- Bibliotecas -->
<link rel="stylesheet" href="css/bootstrap.min.css" />
<link rel="stylesheet" href="css/font-awesome.min.css" />
<link href="css/layout.css" rel="stylesheet" type="text/css">
<script src="js/jquery-2.1.3.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</head>
<body>
<div class="container-fluid">
<header>
    	<nav class="navbar navbar-inverse navbar-fixed-top">
 		<div class="container-fluid">
    <!-- Brand and toggle get grouped for better mobile display -->
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#menu1" aria-expanded="false">
        <span class="sr-only"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <a class="navbar-brand" href="#">
      <small>Sistema verificador</small>
      </a>
    </div>

    <!-- Collect the nav links, forms, and other content for toggling -->
    <div class="collapse navbar-collapse" id="menu1">
      <ul class="nav navbar-nav">
        <li class="active"><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
      </ul>
      <ul class="nav navbar-nav navbar-right">
        <li class="dropdown">
          <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
          <i class="glyphicon glyphicon-user"></i> <?=$pdo->Logado()?> <span class="caret"></span>
          </a>
          <ul class="dropdown-menu">
            <li><a href="#!" data-toggle="modal" data-target="#modal1"><i class="fa fa-cog"></i> Alterar Senha</a></li>
            <li role="separator" class="divider"></li>
            <li><a href="sair.php"><i class="glyphicon glyphicon-log-out"></i> Logout</a></li>
          </ul>
    </div><!-- /.navbar-collapse -->
  </div><!-- /.container-fluid -->
</nav>
</header>
<main>
	<div class="row">
    	<div class="col-md-2">
        <p class="text-center"><img src="images/user-group.png"></p>
        <hr>
        
        <ul class="nav nav-pills nav-stacked">
        	<li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
        	<li><a href="servidor.php"><i class="fa fa-plus"></i> Cadastrar Servidor</a></li>
          <li><a href="#!" data-toggle="modal" data-target="#modalIP"><i class="fa fa-ban"></i> Bloquear IP</a></li>
          <li><a href="user.php"><i class="fa fa-user"></i> Operadores</a></li>
          <li class="active"><a href="estatistica.php"><i class="fa fa-bar-chart"></i> Estatísticas</a></li>
          <li><a href="sair.php"><i class="fa fa-sign-out"></i> Sair</a></li>
        </ul>
      </div>
      <div class="col-md-10">
        	<div class="row">
            <h1 class="titulosistema">Sistema Verificador <i class="fa fa-eye"></i></h1>
        	  <div class="col-md-3">
            	<div class="blocos">
                	<h4>Total de IPs</h4>
					         <h3><i class="fa fa-eye"></i> <?=$TotalIP?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Operadores</h4>
					        <h3><i class="fa fa-users"></i> <?=$TotalUSER?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Servidores</h4>
					         <h3><i class="fa fa-server"></i> <?=$TotalSERV?></h3>
              </div>
            </div>
            <div class="col-md-3">
            	<div class="blocos">
                	<h4>Verificação</h4>
					         <h3><i class="fa fa-comments"></i> Ativa</h3>
              </div>
            </div>
          </div>
          <p>&nbsp;</p>
            <div class="row">
            	<div class="col-md-12">
                	<div class="panel panel-info">
                        <div class="panel-heading">
                            <i class="fa fa-bar-chart"></i> Estatísticas
                        </div>
                        <div class="panel-body">
                          <?php
                          $i = 1;
                          foreach ($csps AS $nome_csp => $csp){  

                            $xml = simplexml_load_string($csp);
                            
                            if(!empty($xml)){

                              $proxystatus = "proxy-status";
                              $jvm = "jvm";
                              $activesessions = "active-sessions";
                              $cspstate = $xml->$proxystatus->attributes()->state;
                              $cspname = $xml->$proxystatus->attributes()->name;
                              $cspversion = $xml->$proxystatus->attributes()->version;
                              $cspbuild = str_replace("r", "", $xml->$proxystatus->attributes()->build);
                              $cspstarted = $xml->$proxystatus->attributes()->started;
                              $cspduration = $xml->$proxystatus->attributes()->duration;
                              $cspconnectors = $xml->$proxystatus->attributes()->connectors;
                              $cspactivesessions = $xml->$proxystatus->attributes()->$activesessions;
                              $cspsessions = $xml->$proxystatus->attributes()->sessions;
                              $jvmname = $xml->$proxystatus->$jvm->attributes()->name;
                              $jvmversion = $xml->$proxystatus->$jvm->attributes()->version;
                              $jvmos = $xml->$proxystatus->$jvm->attributes()->os;
                          ?>

                          <h3>Informações do CSP: <span class="label label-default"><?=$nome_csp?></span></h3>
                          <table class="table table-hover table-striped table-responsive">
                              <tbody>
                                  <tr>
                                    <td width="10%">Servidor:</td>
                                    <td><?=$cspname?></td>
                                  </tr>
                                  <tr>
                                    <td width="10%">Status:</td>
                                    <td><?=$cspstate?></td>
                                  </tr>
                                  <tr>
                                    <td width="10%">Logado:</td>
                                    <td><?=$cspduration?></td>
                                  </tr>
                                  <tr>
                                    <td width="10%">Sessoes:</td>
                                    <td><?=$cspsessions?> (active: <?=$cspactivesessions?>)</td>
                                  </tr>
                              </tbody>
                          </table>
                          <hr>

                          <?php
                            }else{
                            	echo '<h3>Informações do CSP: <span class="label label-default">'.$nome_csp.' OFFLINE ou não cadastrado</span></h3>';
                            }
                          }
                          ?>                                                  
                        </div>
                      </div>
                </div>
            </div>
      </div><!--/COL 10 -->
  </div><!--/ROW  -->
</main>
<footer>
<hr>
<div class="text-center">
<p>Copyright &copy; <?=date('Y');?> - Todos os Direitos Reservados</p>
<p><a href="http://www.desite.com.br" target="_blank">
<img src="images/desite-logo-dashboard.png" width="41" height="19" /> Soluções em sistemas Web</a>
</div>

</footer>

</div><!--/ FIM DA CONTAINER FLUID -->

<?php require_once('includes/modals.php'); ?>

</body>
</html>