<?php
class logar extends myPDO {
	
	//Pega o login do usurio
	private $login;
	//Pega senha do usurio
	private $senha;
	private $pagina;
	// Tabela onde os usuarios so armazenados
	private $tabelalogin;
	//Formulrio de login
	private $paginalogin;
	// Pgina para redirecionamento aps o sucesso do login
	private $paginahome;
	
	private function sessao(){
	    if(!session_id()){
	       return session_start();
	    }
	}
	
	private function redirecionar($pagina){
		$this->pagina = $pagina;
		return header("Location: $this->pagina");
	}
	
	public function __construct($login,$senha,$tabelalogin,$paginahome,$paginalogin){
        
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            
            $this->login = (isset($login) && !empty($login)) ? $this->protecao($login) : false;
            $this->senha = (isset($senha) && !empty($senha)) ? $this->protecao($senha) : false;

            $this->tabelalogin  = (isset($tabelalogin)  && !empty($tabelalogin))    ? $tabelalogin  : false;
            $this->paginahome   = (isset($paginahome)   && !empty($paginahome))     ? $paginahome   : 'home.php';
            $this->paginalogin  = (isset($paginalogin)  && !empty($paginalogin))    ? $paginalogin  : false;

			$buscar = $this->prep("SELECT * FROM {$this->tabelalogin} WHERE us_login=:login AND us_status=:status");
            $buscar->bindValue(':login',$this->login,PDO::PARAM_STR);
            $buscar->bindValue(':status',1,PDO::PARAM_INT);
            $buscar->execute();

            if($buscar->rowCount() === 0){

				$this->redirecionar($this->paginalogin.'?exception=login');
				
			}elseif($buscar->rowCount() === 1){

                $reg      = $buscar->fetch(PDO::FETCH_OBJ);
				$id_us    = $reg->us_id;
				$login    = $reg->us_login;
				$nome_us  = $reg->us_nome;
				$chave_us = $reg->us_senha;
				$status	  = $reg->us_status;

                if(!password_verify($this->senha, $chave_us)){

                unset($id_us);
                unset($nome_us);
				unset($login);
				unset($chave_us);
				unset($nivel);
				
				$this->redirecionar($this->paginalogin.'?exception=senha');

				}else{
					
				$this->sessao();
				
				$sess['ID_SESSAO'] = session_id();
				$sess['IP'] 	   = $_SERVER['REMOTE_ADDR'];
				$sess['ID'] 	   = $id_us;
				$sess['usuario']   = $login;
				$sess['senha'] 	   = $chave_us;
				$sess['LOGADO']    = $nome_us;
				$sess['STATUS']	   = $status;
				/*
				$sess['ON'] = time();
				$sess['END']= time() + 600*2;
				*/
				$_SESSION['ACP']= $sess;
				
				session_write_close();
				$this->redirecionar($this->paginahome);
				
				}
			}
		}	
	}
}
?>