<?php
class Cruds extends myPDO {

	private $tabela;
    private $datas;
    private $where;
    private $result;

    // Selecione um registro baseado no id passado.
    //Utilização: Selec('tabela','campoID','ID');
    public function SelectUm($strtabela,$campoid,$strid){
    	try{

	    	if(!empty($strid) && is_int($strid)){
	    		$busca = $this->prep("SELECT * FROM {$strtabela} WHERE {$campoid} = :cod");
	    		$busca->bindValue(':cod',$strid);
	    		$busca->execute();
	    		if($busca->rowCount() > 0){
	    			return $this->result = $busca->fetch(PDO::FETCH_OBJ);
	    		}
	    	}else{
	    		throw new Exception("Valor incorreto para str");
	    	}

    	}catch(Exception $e){
    		print $e->getMessage();
    	}
    }

    //Cria um registro.
    //$dados['Campo1_da_tabela'] = 'Valor 1';
    //Utilização: Create('tabela',$dados);
	public function Create($strtabela, array $strdatas){	

	 	try {

			if(!empty($strtabela) && is_array($strdatas) && count($strdatas) > 0){
				$this->datas = $strdatas;
				$this->tabela= (string)$strtabela;
			}else{
				throw new Exception('Informe o nome da tabela. Ou você não passou array');
			}

			$fields = implode(", ",array_keys($this->datas));
			$values = "'".implode("', '",array_values($this->datas))."'";
	   		$stCreate = $this->exe("INSERT INTO {$this->tabela} ($fields) VALUES ($values)");

	        if($stCreate){
				return true;
			}else{
				return false;
			}

			$this->fechar();

			}catch(Exception $e){
				print $e->getMessage();
			}

	 }
	
     //Recupera o ID do último registro inserido
	 public function IdFinal(){
		return $this->pdo->lastInsertId();
	    $this->fechar();
	  }
	  
	  public function Update($tabela, array $datas, $where){
		
		$this->datas = $datas;
		$this->tabela= $tabela;
		$this->where = $where;
		
		foreach($this->datas as $fields => $values){
			$campos[] = "$fields = '$values'";
		}
		
		$campos     = implode(", ",$campos);
		$stUpdate   = $this->exe("UPDATE {$this->tabela} SET $campos WHERE {$this->where}");

		if($stUpdate->rowCount() > 0){
			return true;
		}else{
			return false;
		}
   	    $this->fechar();
		
	  }
	  
	  public function Delete($tabela, $where){

        $this->where = $where;
        $this->tabela= $tabela;

		$qrDelete = $this->exe("DELETE FROM {$this->tabela} WHERE {$this->where}");
        if($qrDelete->rowCount() > 0){
		    return true;
        }else{
            return false;
        }
   		$this->fechar();
	  }
     
  }
?>