<?php
class Util {

	private $limpar;
	private $texto;
	private $string;
	private $count;
	private $conteudo;
	private $reduz;

	public function modo(){
    	return $_SERVER['REQUEST_METHOD'];
    }

    public function url(){
        return $_SERVER['QUERY_STRING'];
    }
	
	public function salvarHTML($str){

      	if(!empty($str)){
	      	$this->limpar = $str;
	      	if(!is_numeric($this->limpar)){
	  	    	$this->limpar = htmlspecialchars($this->limpar);
	  	    	return $this->limpar;    	
	      	}
      	}
    }

    public function unhtmlentities($str){
			
		    try{
				
			    if(empty($str)){
					
					throw new Exception('É necessário informar o texto.');
					
				}else{
					
					$this->texto = $str;
				    // replace numeric entities
				    $this->texto = preg_replace('~&#x([0-9a-f]+);~i', 'chr(hexdec("\\1"))', $this->texto);
				    $this->texto = preg_replace('~&#([0-9]+);~', 'chr("\\1")', $this->texto);
				    // replace literal entities
				    $trans_tbl = get_html_translation_table(HTML_ENTITIES);
				    $trans_tbl = array_flip($trans_tbl);
				    return strtr($this->texto, $trans_tbl);			
		    
		    	}
		    
		    }catch(Exception $e){
				
				return '<br><br>ERRO:<br>'.$e->getMessage().' | Arquivo de origem da excessão: '.$e->getFile().'<br> Na linha: '.$e->getLine();				
			}
		}

    public function checkAjax(){
    	return (isset($_SERVER['HTTP_X_REQUESTED_WITH'])) ? true : false;
	}

	public function ReduzTexto($str,$limite=100){
		
		$this->reduz  = strip_tags($str);
		$this->count  = strlen($this->reduz);
		
		if($this->count <= $limite){
			return $this->reduz;
		}else{
			$strpos = strrpos(substr($this->reduz,0,$limite),' ');
			return substr($this->reduz,0,$strpos).'...';
		}
	}

}