<?php
	/*
	 * Dica: Sempre mantenha os arquivos de download em uma mesma pasta, separada dos arquivos do site.
	 * Neste script usaremos a pasta download para esta funo.
	 */

	$arquivo = 'nrcs.sql'; // Nome do Arquivo
	$local = '/var/www/html/lib-nrcs/download/'; // Pasta que contm os arquivos para download
	$local_arquivio = $local.$arquivo; // Concatena o diretrio com o nome do arquivo
	
	/*
	 * Por segurana, o script verifica se o usurio esta tentato sair da pasta especificada para 
	 * os arquivos de download (stripos($arquivo, './') !== false || stripos($arquivo, '../') !== false),
	 * isso ir bloquear a tentativa de forar download de arquivos no permitidos.
	 * Na mesma funo verificamos se o arquivo existe (!file_exists($arquivo)).
	 */
    if(stripos($arquivo, './') !== false || stripos($arquivo, '../') !== false || !file_exists($local_arquivio))
    {
    	echo 'O comando no pode ser executado.';
    }
    else
    {
	    header('Cache-control: private');
	    header('Content-Type: application/octet-stream');
	    header('Content-Length: '.filesize($local_arquivio));
	    header('Content-Disposition: filename='.$arquivo);
	    header("Content-Disposition: attachment; filename=".basename($local_arquivio));
	    
	    // Envia o arquivo Download
		readfile($local_arquivio);
    }
?>