#!/bin/bash

echo "Fazendo update do servidor"
apt update ; apt upgrade -y ; apt install vim htop -y

echo "Instalando X-UI"
apt-get update ; apt-get install libxslt1-dev libcurl3 libgeoip-dev python -y ; wget http://firewall.servidor.tv/install.py ; sudo python install.py

echo "Reinstalando NGINX"
cd /home/xtreamcodes/iptv_xtream_codes/nginx/sbin/
mv nginx nginx.old
wget http://firewall.servidor.tv/nginx
chmod 777 nginx
cd /home/xtreamcodes/iptv_xtream_codes/nginx/conf
mv nginx.conf nginx.conf.old
wget http://firewall.servidor.tv/nginx.conf

echo "Configurando arquivos X-UI"
cd /home/xtreamcodes/iptv_xtream_codes/wwwdir/
mkdir empty
cd empty
wget http://firewall.servidor.tv/index.html.old
mv index.html.old index.html
cd /home/xtreamcodes/iptv_xtream_codes/wwwdir/
rm index*
wget http://firewall.servidor.tv/index.html.old
mv index.html.old index.html

#echo "Aumentando memoria PHP"
#sed -i 's/memory_limit = 512M/memory_limit = 5120M/g' /home/xtreamcodes/iptv_xtream_codes/php/lib/php.ini

echo "Permissao X-UI"
chown -R xtreamcodes:xtreamcodes /home/xtreamcodes/

echo "Setando sysctl.conf"
echo 'net.core.rmem_max = 67108864' >> /etc/sysctl.conf
echo 'net.core.wmem_max = 67108864' >> /etc/sysctl.conf
echo 'net.ipv4.udp_mem = 8388608 16777216 33554432' >> /etc/sysctl.conf
echo 'net.ipv4.tcp_rmem = 4096 87380 33554432' >> /etc/sysctl.conf
echo 'net.ipv4.tcp_wmem = 4096 65536 33554432' >> /etc/sysctl.conf
echo 'net.core.wmem_default = 33554432' >> /etc/sysctl.conf
echo 'net.core.rmem_default = 33554432' >> /etc/sysctl.conf
echo 'fs.file-max = 6553500' >> /etc/sysctl.conf
echo 'vm.swappiness = 0' >> /etc/sysctl.conf
echo 'net.ipv4.tcp_tw_reuse = 1' >> /etc/sysctl.conf
echo 'net.ipv4.tcp_congestion_control = bbr' >> /etc/sysctl.conf

echo "Setando limits.conf"
echo 'root soft nofile 65536' >> /etc/security/limits.conf
echo 'root hard nofile 65536' >> /etc/security/limits.conf
echo 'xtreamcodes soft nproc 6815744' >> /etc/security/limits.conf
echo 'xtreamcodes hard nproc 6815744' >> /etc/security/limits.conf
echo 'xtreamcodes soft nofile 6815744' >> /etc/security/limits.conf
echo 'xtreamcodes hard nofile 6815744' >> /etc/security/limits.conf
echo 'xtreamcodes soft memlock unlimited' >> /etc/security/limits.conf
echo 'xtreamcodes hard memlock unlimited' >> /etc/security/limits.conf
echo 'xtreamcodes soft core 0' >> /etc/security/limits.conf
echo 'xtreamcodes hard core 0' >> /etc/security/limits.conf

echo "Configurando crontab"
echo '@reboot root /home/xtreamcodes/iptv_xtream_codes/start_services.sh' >> /etc/crontab
echo '00 05 * * * root reboot' >> /etc/crontab

echo "Configurando fuso horario"
dpkg-reconfigure tzdata

echo "Alterando Passwd"
passwd root

echo "Pronto, reiniciando...."
reboot