<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * @property CI_DB_active_record $db
 * @property CI_DB_forge $dbforge
 * @property CI_Benchmark $benchmark
 * @property CI_Calendar $calendar
 * @property CI_Cart $cart
 * @property CI_Config $config
 * @property CI_Controller $controller
 * @property CI_Email $email
 * @property CI_Encrypt $encrypt
 * @property CI_Exceptions $exceptions
 * @property CI_Form_validation $form_validation
 * @property CI_Ftp $ftp
 * @property CI_Hooks $hooks
 * @property CI_Image_lib $image_lib
 * @property CI_Input $input
 * @property CI_Language $language
 * @property CI_Loader $load
 * @property CI_Log $log
 * @property CI_Model $model
 * @property CI_Output $output
 * @property CI_Pagination $pagination
 * @property CI_Parser $parser
 * @property CI_Profiler $profiler
 * @property CI_Router $router
 * @property CI_Session $session
 * @property CI_Sha1 $sha1
 * @property CI_Table $table
 * @property CI_Trackback $trackback
 * @property CI_Typography $typography
 * @property CI_Unit_test $unit_test
 * @property CI_Upload $upload
 * @property CI_URI $uri
 * @property CI_User_agent $user_agent
 * @property CI_Validation $validation
 * @property CI_Xmlrpc $xmlrpc
 * @property CI_Xmlrpcs $xmlrpcs
 * @property CI_Zip $zip
 * @property Sessao_nativa $sessao_nativa
 */
abstract class MY_Controller extends CI_Controller {

    public function __construct() {

        parent::__construct();

        $token_acesso = $this->sessao_nativa->get('token_acesso');
        $login_revenda = $this->sessao_nativa->get('loginuser');
        $login_level = $this->sessao_nativa->get('adminlevel');
        $rev_pre = $this->sessao_nativa->get('rev_pre');
        
        if($token_acesso === null || $token_acesso === "" || $login_revenda === null || $login_revenda === "" || ($login_level == "1" && $rev_pre == "0")){
            redirect('login/logout');
            exit();
        }
    }

    public function _antiSqlInject($value = null) {

        $sanitizeRules = array(' OR ', ' OR', 'FROM', 'SELECT', 'INSERT', 'DELETE', 'WHERE', 'DROP TABLE', 'SHOW TABLES', ' *', '--', '<SCRIPT>', '<script>', '</SCRIPT>', '</script>');

        if (is_array($value)) {
            $value = $this->_antiSqlInjectArray($value);
        } else {
            $value = (!get_magic_quotes_gpc()) ? addslashes(str_ireplace($sanitizeRules, "", $value)) : str_ireplace($sanitizeRules, "", $value);
        }
        return $value;
    }

    private function _antiSqlInjectArray($Target = null) {

        $sanitizeRules = array(' OR ', ' OR', 'FROM', 'SELECT', 'INSERT', 'DELETE', 'WHERE', 'DROP TABLE', 'SHOW TABLES', ' *', '--', '<SCRIPT>', '<script>', '</SCRIPT>', '</script>');


        foreach ($Target as $key => $value) {

            if (is_array($value)) {
                $arraSanitized[$key] = $this->_antiSqlInject($value);
            } else {
                $arraSanitized[$key] = (!get_magic_quotes_gpc()) ? addslashes(str_ireplace($sanitizeRules, "", $value)) : str_ireplace($sanitizeRules, "", $value);
            }
        }

        if (isset($arraSanitized)) {
            return $arraSanitized;
        }
    }

}
