<?php header('Content-Type: text/html; charset=utf-8'); ?>
<?php date_default_timezone_set('America/Sao_Paulo'); ?>
<?php

require("config.php");
require("includes/debug.php");
require("includes/functions.php");

//include "includes/PagSeguroLibrary/PagSeguroLibrary.php";

$ips_ps = array(
    '186.234.16.8',
    '186.234.16.9',
    '186.234.48.8',
    '186.234.48.9',
    '186.234.144.17',
    '186.234.144.18',
    '200.147.112.136',
    '200.147.112.137',
    '179.155.106.48',
    '::1');

$ip_requisicao = $_SERVER['REMOTE_ADDR'];

if (array_search($ip_requisicao, $ips_ps) === false) {

    $mensagem_log = date('d/m/Y H:i:s') . ": --- IP : {$ip_requisicao} Não permitido ---<br/>";
    error_log($mensagem_log, 3, 'logs/notificacoes.html');
    exit();
}
//Pegando credencias da revenda
//$id = is_numeric($_GET['aid']) ? $_GET['aid'] : exit(); // ID Rerevenda

$r = isset($_GET['r']) ? $_GET['r'] : null;

if (null === $r) {

    exit();
}

$id_revenda = (int) dpt(base64_url_decode($r), $s);

$con = mysqli_connect($dbhost, $dbuser, $dbpass, $dbname);

$rs = $con->query("SELECT email_ps,token_ps FROM cmum_admins WHERE id = '{$id_revenda}'");


//incluindo a library pagseguro
require_once "includes/PagSeguroLibrary/PagSeguroLibrary.php";

if ($rs->num_rows > 0) {

    $row = $rs->fetch_assoc();

    /* Informando as credenciais  */
    $credentials = new PagSeguroAccountCredentials(
            $row['email_ps'], $row['token_ps']
    );
} else {
    $mensagem_log = date('d/m/Y H:i:s') . ": --- Error ao buscar email e token revenda ---<br/>";
    error_log($mensagem_log, 3, 'logs/notificacoes.html');
}

/* Tipo de notificação recebida */
$type = $_POST['notificationType'];

/* Código da notificação recebida */
$codigo_notificao = $_POST['notificationCode'];

/* Verificando tipo de notificação recebida */
if ($type === 'transaction') {

    /* Obtendo o objeto PagSeguroTransaction a partir do código de notificação */
    $transaction = PagSeguroNotificationService::checkTransaction(
                    $credentials, $codigo_notificao // código de notificação  
    );

    $id_referencia = json_decode($transaction->getReference(), true); //'tipo' => 'L', 'id' => 1)
    $status_trans = $transaction->getStatus()->getValue();
    $metodo_pag = $transaction->getPaymentMethod()->getType()->getValue();
    $codigo_pag = $transaction->getPaymentMethod()->getCode()->getValue();

    //status cmum_transacao
    $tabelas_status_int[0] = 'Cancelada';
    $tabelas_status_int[1] = 'Aberta';
    $tabelas_status_int[2] = 'Aguardando Pagamento';
    $tabelas_status_int[3] = 'Aprovada';
    $tabelas_status_int[4] = 'Problemas com cliente';
    $tabelas_status_int[5] = 'Fechada';

    //Tabela Status pagseguro
    $tabela_status[0] = 'Incompleta';
    $tabela_status[1] = 'Aguardando pagamento';
    $tabela_status[2] = 'Em análise';
    $tabela_status[3] = 'Paga';
    $tabela_status[4] = 'Disponível';
    $tabela_status[5] = 'Em disputa';
    $tabela_status[6] = 'Devolvida';
    $tabela_status[7] = 'Cancelada';

    //Tabela Metodo Pagamento pagseguro
    $tabela_metodo_pag[0] = '-';
    $tabela_metodo_pag[1] = 'Cartão de crédito';
    $tabela_metodo_pag[2] = 'Boleto';
    $tabela_metodo_pag[3] = 'Débito online (TEF)';
    $tabela_metodo_pag[4] = 'Saldo PagSeguro';
    $tabela_metodo_pag[5] = 'Oi Paggo';
    $tabela_metodo_pag[7] = 'Depósito em conta';

    //transacao criada por login
    if ($id_referencia['tipo'] == 'L') {


        /*
          id	int(11)	Não
          id_user	int(11)	Não
          id_revenda	int(11)	Não
          tipo	int(11)	Não
          valor_un	decimal(10,2)	Não
          qtd_meses	int(11)	Não
          valor_total	decimal(10,2)	Não
          detalhes
          data_cad	datetime	Não
          data_atualizacao	datetime	Não
          status
         */

        $datalhes = "<p><strong>Status PagSeguro:</strong> {$tabela_status[$status_trans]}<br/>"
                . "<strong>Metodo de Pagamento:</strong> {$tabela_metodo_pag[$codigo_pag]}<br/>"
                . "<strong>COD. Notificação PagSeguro:</strong> {$codigo_notificao}</p>";

        $detalhes = htmlentities($datalhes);

        if ($status_trans == '0') {

            $status = 1;
        } elseif ($status_trans == '1' || $status_trans == '2') {

            $status = 2;
        } elseif ($status_trans == '3' || $status_trans == '4') {

            $status = 3;
        } elseif ($status_trans == '5' || $status_trans == '6') {

            $status = 4;
        } else {

            $status = 0;
        }

        $data_atualizacao = date('Y-m-d H:i:s');


        $rs = $con->query("UPDATE cmum_transacoes SET "
                . "detalhes='{$datalhes}',"
                . "status='{$status}',"
                . "data_atualizacao='$data_atualizacao'"
                . " WHERE id={$id_referencia['id']}");

        if ($rs === true) {

            //ativado o login
            if ($status_trans == '3') {//ativado de acordo com o status do pagseguro
                if (atualiza_venc_login($id_referencia['id'])) {

                    $log = date('d/m/Y H:i:s') . ": --- Status transação [aprovada] e vencimento login alterado com sucesso.---<br/>";
                    error_log($log, 3, 'logs/notificacoes.html');
                    
                }
            } else {

                $mensagem_log = date('d/m/Y H:i:s') . ": --- Status transação alterado ---<br/>";
                error_log($mensagem_log, 3, 'logs/notificacoes.html');
            }
        }
    }// if tipo transacao
} else {

    $mensagem_log = date('d/m/Y H:i:s') . ": --- Tipo de transação inválida ---<br/>";
    error_log($mensagem_log, 3, 'logs/notificacoes.html');
    echo "--- Tipo de transação inválida ---";
}  