<?php header('Content-Type: text/html; charset=utf-8'); ?>
<?php
require("config.php");
require("includes/debug.php");
require("includes/functions.php");

//historico de url referencia

$_SESSION['URL_REFERER'][] = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : null;

$r = isset($_GET['r']) ? $_GET['r'] : null;

if (null === $r) {

    exit();
}

$id_revenda = (int) dpt(base64_url_decode($r), $s);

if (checkar_permissao_rev($id_revenda, "11") === false) {

    exit();
}

//informações da revenda

$dados_rev = dados_revenda($id_revenda, 'level');

$titulo = 'Formulário de Pedidos de Testes';

//perfis disponiveis

if ($dados_rev['level'] == '1') {

    $perfis_disp = perfis_disponiveis_revenda($id_revenda);
} else {

    $perfis_disp = perfis_disponiveis_adm();
}


$config_salvo = config_painel('tempo_login_teste,mult_perf,id_modelo_padrao');

// quando o formulario for enviado

if (count($_POST) > 0) {

    $nome = $_POST['nome'];
    $email = $_POST['email'];
    $perfis = isset($_POST['perfil']) ? $_POST['perfil'] : null;

    if (is_null($nome) || $nome === "") {

        $javascript = <<<EOF
                <script charset="UTF-8">
                    alert('Preencha o campo de nome corretamente.');
                    window.history.go(-1);
                </script>
EOF;
        exit($javascript);
    }

    if (filter_var($email, FILTER_VALIDATE_EMAIL) === false) {

        $javascript = <<<EOF
                <script charset="UTF-8">
                    alert('Preencha o campo de email corretamente.');
                    window.history.go(-1);
                </script>
EOF;
        exit($javascript);
    }

// verifica se já existe um teste pedido 

    $teste_existente = check_teste_pedido($email);

    if (!empty($teste_existente)) {

        $data_cad = date('d/m/Y', strtotime($teste_existente['data_cad']));

        $javascript = <<<EOF
                <script charset="UTF-8">
                    alert('Existe um teste pra este email cadastrado em: {$data_cad}');
                    window.history.go(-1);
                </script>
EOF;
        exit($javascript);
    }

    $lista_negra = listaNegra($email);

    //verifica se o dominio do email tá na lista negra
    if ($lista_negra === true) {

        $javascript = <<<EOF
                <script charset="UTF-8">
                    alert('Ocorreu um erro de cadastro, tente novamente mais tarde.');
                    window.history.go(-1);
                </script>
EOF;
        exit($javascript);
    }

    //se não tiver perfil cadastrado ou tiver bloqueado
    if (null === $perfis || empty($perfis)) {

        $javascript = <<<EOF
                <script charset="UTF-8">
                    alert('Não foi selecionado uma Operadora/Região. Caso a opção não esteja disponivel, tente novamente em outro momento.');
                    window.history.go(-1);
                </script>
EOF;
        exit($javascript);
    }

    //recupera o valor cobrado global
    $dados_revenda = dados_revenda($id_revenda, 'valor_cobrado_global,id_modelo_padrao');

    $login_teste['name'] = gera_login_rand($email);
    $login_teste['displayname'] = $nome;
    $login_teste['password'] = mt_rand(100, 999);
    $login_teste['profiles'] = serialize($perfis);
    $login_teste['email'] = strtolower(trim($email));
    $login_teste['maxconnections'] = count($perfis);
    $login_teste['enabled'] = 'true';
    $login_teste['startdate'] = date("Y-m-d");
    $login_teste['added'] = $login_teste['startdate'];
    $login_teste['expiredate'] = date("Y-m-d H:i:s", strtotime("+{$config_salvo['tempo_login_teste']} hours"));
    $login_teste['addedby'] = $id_revenda;
    $login_teste['obs_user'] = 'Login criado automaticamente através do formulário.';
    $login_teste['valor_cob'] = $dados_revenda['valor_cobrado_global'];

    // cadastra novo login teste    
    if (add_login_teste($login_teste)) {

        // registra o teste pedido


        $teste_pedido['email'] = strtolower(trim($email));
        $teste_pedido['addedby'] = $id_revenda;
        $teste_pedido['data_cad'] = date("Y-m-d");
        $teste_pedido['ip'] = $_SERVER['REMOTE_ADDR'];
        $teste_pedido['url_ref'] = $_SESSION['URL_REFERER'][0];

        //registra teste        
        registra_teste_pedido($teste_pedido);

        // pega o modelo salvo na revenda
        $modelo_email = modelo_email_revenda($id_revenda, $dados_revenda['id_modelo_padrao']);

        //se não houve na revenda pegado sistema        
        if (empty($modelo_email)) {

            $modelo_email = modelo_email_sistema($config_salvo['id_modelo_padrao']);
        }

        //configurações do email para envio

        /*
          id	int(11)	Não
          uid	int(11)	Não
          email	varchar(50)	Não
          nome_exibir	varchar(25)	Não
          senha	varchar(50)	Não
          serv_mail	varchar(25)	Não
          data_cad	datetime	Não
          data_atu	datetime
         */

        $config_email_revenda = email_envio_revenda($id_revenda);

        if (empty($config_email_revenda) || empty($modelo_email)) {
            
            $javascript = <<<EOF
                <script charset="UTF-8">
                    alert('O login teste foi criado com sucesso, não foi enviado email pois os dados não estão configurados corretamente.');
                    window.history.go(-1);
                </script>
EOF;
            exit($javascript);
        }

        // variaveis do modelo de email.

        $var_email['[EMVENDEDOR]'] = $config_email_revenda['email'];
        $var_email['[NMVENDEDOR]'] = $config_email_revenda['nome_exibir'];
        $var_email['[LGCLIENTE]'] = $login_teste['name'];
        $var_email['[SNCLIENTE]'] = $login_teste['password'];
        $var_email['[NMCLIENTE]'] = $login_teste['displayname'];
        $var_email['[VCCLIENTE]'] = date("d/m/Y H:i:s", strtotime($login_teste['expiredate']));
        $var_email['[DDSERVIDOR]'] = html_url_profiles(urls_profiles($id_revenda)); //'Dados servidor.(urls,portas)';
        //substituindo variaveis de email no assunto e no corpo
        $assunto = str_replace(array_keys($var_email), array_values($var_email), $modelo_email['assunto']);
        $corpo = str_replace(array_keys($var_email), array_values($var_email), $modelo_email['corpo']);

        //variaveis para envio do email
        $dados_envio['para_email'] = $email;
        $dados_envio['de_email'] = $config_email_revenda['email'];
        $dados_envio['de_nome'] = $config_email_revenda['nome_exibir'];
        $dados_envio['de_senha'] = dpt($config_email_revenda['senha'], $s);
        $dados_envio['assunto_email'] = $assunto;
        $dados_envio['corpo_email'] = $corpo;
        $dados_envio['servidor_email'] = $config_email_revenda['serv_mail'];        
        //var_dump($dados_envio);exit();
        
        //processando o envio do email
        smtpmailer3($dados_envio);

        $javascript = <<<EOF
                <script charset="UTF-8">
                    alert('Login criado com sucesso. Já foi enviado um email com os dados do login teste.');
                    window.location.replace('{$_SESSION['URL_REFERER'][0]}');
                </script>
EOF;
        exit($javascript);
    }// if add_login
}// if $_POST
?>
<!-- topo -->
<?php require_once 'includes/topo.php'; ?>
<div class="container">           
    <div class="col-sm-6 col-sm-offset-3">
<tr>
                                <td height="36">     <img src="teste.png" name="center" width="530" height="180" align="center"></td>
                            </tr>
        <h5><?= $titulo; ?></h5>
        <div class="alert alert-warning">
            Atualmente os testes estão configurados para <?= $config_salvo['tempo_login_teste']; ?>  horas.          
        </div>
        <form method="post">
            <div class="form-group">
                <label>Seu nome:</label><input class="form-control" name="nome"/>                
            </div>
            <div class="form-group">
                <label>Email:</label><input class="form-control" name="email"/>                
            </div>
            <div class="form-group">
                <label>Operadora/Região Disponivel:</label>
<?php if (count($perfis_disp) > 0): ?>
                    <?php foreach ($perfis_disp as $perfil): ?>
                        <div><input name="perfil[]" type="<?= ($config_salvo['mult_perf'] == '0') ? 'radio' : 'checkbox' ?>" value="<?= $perfil['id'] ?>"/>&nbsp;<?= strtoupper($perfil['name']) ?></div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="alert alert-danger">Não existem opções disponiveis no momento.</div>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <button class="btn btn-primary" <?php if (empty($perfis_disp) || count($perfis_disp) == 0): ?>disabled="true"<?php endif; ?>>Solicitar</button>
            </div>        
        </form>
        <hr/>
        <p class="text-center">Todos direitos reservados</p>
    </div>
</div>
</body>
</html>
