-include_lib("corelib/include/corelib_openapi.hrl").
-ifdef(MEDIA_INFO_HRL).
-error(already_included_media_info_hrl).
-else.
-define(MEDIA_INFO_HRL,true).
-endif.


-type deprecated(X) :: X.
-type wrong_typed(X) :: X.


-type binary_int() :: binary().  % То, что должно парситься в инт, но пробрасывается бинарем
-type binary_value() :: binary(). % То, что должно парситься в атом, но отдается бинарем
-type binary_boolean() :: binary().

-type(frame_flavor()  ::frame|keyframe|config|disposable).
-type(frame_video_color_space() ::gbr|bt709|unknown|reserved|fcc|bt470bg|smpte170m|smpte240m|ycgco|bt2020nc|bt2020c|smpte2085|'chroma-derived-nc'|'chroma-derived-c'|ictcp).




-type(frame_sound_channels() ::mono|stereo).
-type(frame_sound_size() ::bit8|bit16).
-type(frame_sound_rate() ::rate5|rate11|rate22|rate44).
% -type(frame_sound() ::{frame_sound_channels(), frame_sound_size(), frame_sound_rate()}).



-record(ad_splice, {
  % все таймстемпы в миллисекундах
  id :: integer(),
  type :: splice_insert | private_command,
  at :: ticks(),
  out :: boolean(),
  duration :: integer(),
  scte35 :: binary(),
  time_shift = 0,
  elapsed :: integer(),
  in :: before_out | after_out,
  cont :: boolean(),
  auto_return :: boolean()
}).

-record(splicing, {
  splice :: #ad_splice{},
  announces = [] :: [#ad_splice{}]
}).

-type(splicing() :: #splicing{}).



-record(video_frame,{
  content        = undefined ::frame_content(),
  dts            = 0.0 ::ticks(),
  pts            = 0.0 ::ticks(),
  duration       = undefined :: ticks(),
  stream_id      = 0         ::non_neg_integer(),
  codec          ::frame_codec(),
  flavor         ::frame_flavor(),
  track_id       = 0 ::non_neg_integer(),
  body           = <<>>      ::binary(),
  next_id        = undefined ::any(),
  mpegts         ::binary(),
  source         = undefined :: any(),
  options        = #{} :: any(),
  splicing       = undefined :: splicing()
}).


-record(epg_event, {
  stream_id,
  source,
  id :: non_neg_integer(), % event_id
  start :: utc(), % start_time
  duration :: non_neg_integer(), % duration
  status :: atom(), % running_status
  language :: binary(), % short_event_descriptor.language
  name :: binary(), % short_event_descriptor.event_name
  about :: binary(), % short_event_descriptor.text
  encrypted :: boolean(), % free_CA_mode
  rating, % parental_rating_descriptor decoded
  genre, % content_descriptior decoded
  ext % extended_event_descriptor decoded :: [{lang,Lang::binary()},{text,Text::binary()}]
}).

-define(FIRST_JAN_2018, 1514764800).

-define(DTS_IS_US,false).

-define(MIN_SECOND,1000000000).
-define(MAX_SECOND,2000000000).
-define(MIN_MILLI_SECOND, 1000000000000).
-define(MAX_MILLI_SECOND, 2000000000000).
-define(MIN_MICRO_SECOND, 1000000000000000).
-define(MAX_MICRO_SECOND, 2000000000000000).



-if(?DTS_IS_US).
% Микросекунды
-define(TICKS_IN_MS, 1000).
-define(TICKS_WORD, "us").
-define(NOW_TICKS(), minute:now_us()).
-define(KHZ90_TO_TICKS(X), (((X)*1000) div 90)).
-define(TICKS_TO_KHZ90(X), (((X)*90) div 1000)). % *90/1000 = *0.09 = /11
-define(TICKS_TO_MHZ27(X), ((X)*27)).
-define(TICKS_TO_SEC(X), ((X) div 1000000)).
-define(TICKS_TO_MS(X), ((X) div 1000)).
-define(TICKS_TO_US(X), (X)).
-define(SEC_TO_TICKS(X), round((X)*1000000)).
-define(MS_TO_TICKS(X), round((X)*1000)).
-define(US_TO_TICKS(X), (X)).

-define(MIN_TICK, ?MIN_MICRO_SECOND).
-define(MAX_TICK, ?MAX_MICRO_SECOND).

-else.
% Дробные миллисекунды
-define(TICKS_IN_MS, 1).
-define(TICKS_WORD, "ms").
-define(NOW_TICKS(), minute:now_ms()).
-define(KHZ90_TO_TICKS(X), ((X) / 90)).
-define(TICKS_TO_KHZ90(X), round((X)*90)).
-define(TICKS_TO_MHZ27(X), round((X)*27000)).
-define(TICKS_TO_SEC(X), trunc((X)/1000)).
-define(TICKS_TO_MS(X), (X)).
-define(TICKS_TO_US(X), trunc((X)*1000)).
-define(SEC_TO_TICKS(X), ((X)*1000.0)).
-define(MS_TO_TICKS(X), ((X)*1.0)).
-define(US_TO_TICKS(X), ((X)/1000)).

-define(MIN_TICK, (?MIN_MILLI_SECOND)).
-define(MAX_TICK, (?MAX_MILLI_SECOND)).

-endif.



-record(segment,{
  opened_at :: seconds(), % expected to be in seconds
  dts :: ticks(),
  number :: non_neg_integer(),
  duration :: ticks(),
  drm_key,
  body    :: binary(),
  jpeg,
  frog,
  locked = false,
  discontinuity = false,
  skip_storage = false,
  media_info,

  % options = [],
  % It's pid of process which create this segment
  source :: any(),
  ad :: undefined | #ad_splice{},
  ad_extra = [] :: [#ad_splice{}],
  % Where we found this segment
  source_type = ram :: ram|dvr_cache|dvr_remote|dvr_local,
  % Pid of process which requested creating segment
  requester
}).


-record(stream_status, {
  source,
  status
}).



-type(video_frame() :: #video_frame{}).
-type segment() :: #segment{}.








-define(AUDIO_PARAMS_FIELDS_USER,
  ,sample_fmt :: binary_value(), %  = <<"fltp">>
  channel_layout = undefined :: binary_value(),
  samples     = 0 ::non_neg_integer(),
  config      = undefined :: any()
).



-define(TRACK_INFO_FIELDS_USER,
  ,orig_track_id  = undefined ::non_neg_integer(),
  drm_key        = undefined ::any(), %% требуется только для вызова mp4_writer
  options        = []        ::[any()]
).



-define(MEDIA_INFO_FIELDS_USER,
  ,source     = undefined :: any(),
  options    = [] :: [any()]
).



-define(DEFAULT_BUFFER_LENGTH, 60). % параметр mpegts_output_buffer





-include("media_info_openapi.hrl").


%%% codecs
%%% This defines are used to make implementing a new codec easier.

-define(IS_AV_CODEC(C),   (?IS_VIDEO_CODEC(C) orelse ?IS_AUDIO_CODEC(C))).
% -define(IS_AVT_CODEC(C),  (?IS_VIDEO_CODEC(C) orelse ?IS_AUDIO_CODEC(C) orelse (?IS_TEXT_CODEC(C) andalso C =/= scte35))).
% -define(IS_AVTC_CODEC(C), (?IS_AVT_CODEC(C) orelse C == scte35).

-define(IS_MPEGTS_AUDIO_CODEC(C), (?IS_AUDIO_CODEC(C) andalso C =/= pcma andalso C =/= pcmu)).
-define(IS_MPEGTS_TEXT_CODEC(C),  (C == ttxt orelse C == subtitle)).
-define(IS_MPEGTS_AV_CODEC(C),    (?IS_MPEGTS_AUDIO_CODEC(C) orelse ?IS_VIDEO_CODEC(C))).
-define(IS_MPEGTS_AVT_CODEC(C),   (?IS_MPEGTS_AV_CODEC(C) orelse ?IS_MPEGTS_TEXT_CODEC(C))).
-define(IS_MPEGTS_AVTC_CODEC(C),  (?IS_MPEGTS_AVT_CODEC(C) orelse (C == scte35))).

-define(IS_HLS_AVT_CODEC(C), (?IS_VIDEO_CODEC(C) orelse ?IS_TEXT_CODEC(C) orelse
    (C == aac orelse C == mp3 orelse C == mp2a orelse C == ac3 orelse C == eac3) orelse
    (C == mpegts))).

-define(IS_MP4_AV_CODEC(C), (C == h264 orelse C == hevc orelse C == mp2v orelse
    C == av1 orelse
    C == aac orelse C == mp3 orelse C == mp2a orelse C == ac3 orelse C == eac3 orelse C == opus)).

-define(IS_RTSP_AV_CODEC(C), (C == h264 orelse C == hevc orelse C == aac orelse C == mp3 orelse C == pcma orelse C == pcmu
    orelse C == av1
    orelse C == mpegts orelse C == onvif orelse C == mp2a orelse C == jpeg)).

-define(IS_FLV_VIDEO_CODEC(C), (C == screen)).

-define(IS_WEBRTC_AUDIO_CODEC(C), (C == pcma orelse C == pcmu orelse C == opus)).
-define(IS_WEBRTC_VIDEO_CODEC(C), (C == av1 orelse C == h264 orelse C == vp8 orelse C == vp9)).
-define(IS_WEBRTC_AV_CODEC(C), (?IS_WEBRTC_AUDIO_CODEC(C) orelse ?IS_WEBRTC_VIDEO_CODEC(C))).

%%% end codecs


-type(video_params() :: #video_params{}).
-type(audio_params() :: #audio_params{}).
-type(track_info() :: #track_info{}).
-type media_info() :: #media_info{}.

% название stream_event вызвало некоторое непонимание
% на момент его появления оно сигнализировало о некоторых событиях только в источнике
% был вариант source_event, но пока решили оставить так
-record(stream_event, {
  stream_id   = undefined :: binary(),              % имя стрима
  source      = undefined :: pid(),                 % pid процесса источника в котором возник event
  timestamp   = undefined :: ticks(),               % now_ms, в который был сгенерирован эвент
  pid         = undefined :: pid(),                 % pid процесса, в котором был сгенерирован эвент
  event       = undefined :: decoder_reset,         % Название эвента
  meta        = #{}       :: #{atom() => any()}  % та же мета, что передаётся в эвент"
}).
