from flask import Blueprint, render_template_string, request

from watcher.models import User
from watcher.request import http_auth_required_if_not_configured
from watcher.version import version as WATCHER_VERSION
from watcher.sysconf import config
v2_index_bp = Blueprint('v2_index', __name__, static_folder='static')


@v2_index_bp.route('/')
@v2_index_bp.route('/<path:path>')
@http_auth_required_if_not_configured
def v2_index(*args, **kw):
  ctx = {
    'backend': 1,
    'configuration_required': 0,
    'sentry_dsn': config.sentry_dsn,
    'version': WATCHER_VERSION,
  }
  if not User.watcher_is_configured():
    ctx['configuration_required'] = 1
    ctx['authorization'] = request.headers['Authorization']

  with v2_index_bp.open_resource('static/index.html') as f:
    return render_template_string(f.read().decode(), **ctx)
