"""streamer_status_unix_ts_mixin

Revision ID: 28aa3341b901
Revises: ee1f6508aae0
Create Date: 2021-10-19 14:40:36.987399

"""

# revision identifiers, used by Alembic.
revision = '28aa3341b901'
down_revision = 'ee1f6508aae0'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column(
    'streamer_statuses',
    sa.Column(
      'created_at_ts',
      sa.BigInteger(),
      server_default=sa.text('floor(EXTRACT(epoch FROM now()))'),
      nullable=False
    )
  )
  op.add_column(
    'streamer_statuses',
    sa.Column(
      'updated_at_ts',
      sa.BigInteger(),
      server_default=sa.text('floor(EXTRACT(epoch FROM now()))'), nullable=False
    )
  )


def downgrade():
  op.drop_column('streamer_statuses', 'updated_at_ts')
  op.drop_column('streamer_statuses', 'created_at_ts')
