"""delete_metrics_table

Revision ID: acc59ffa0208
Revises: v21.05
Create Date: 2021-05-17 13:13:20.434595

"""

# revision identifiers, used by Alembic.
revision = 'acc59ffa0208'
down_revision = 'v21.05'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
    op.drop_table('watcher_metrics')


def downgrade():
    op.create_table(
        'watcher_metrics',
        sa.Column('pid', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column('name', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column('type', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column('help', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column(
            'timestamps',
            postgresql.ARRAY(postgresql.DOUBLE_PRECISION(precision=53)),
            server_default=sa.text("'{}'::double precision[]"),
            autoincrement=False, nullable=False
        ),
        sa.Column(
            'samples',
            postgresql.ARRAY(postgresql.JSONB(astext_type=sa.Text())),
            server_default=sa.text("'{}'::jsonb[]"), autoincrement=False, nullable=False),
        sa.PrimaryKeyConstraint('pid', 'name', name='watcher_metrics_pk')
    )
