"""separate_camera_agents

Revision ID: 593f289036c8
Revises: 9b4836c1979d
Create Date: 2021-04-08 15:47:02.976989

"""

# revision identifiers, used by Alembic.
revision = '593f289036c8'
down_revision = '9b4836c1979d'

import warnings
from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy import exc as sa_exc
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  op.create_table(
    'agents',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('key', sa.String(), nullable=True),
    sa.Column('model', sa.String(), nullable=True),
    sa.Column('serial', sa.String(), nullable=True),
    sa.Column('registered_at', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
  )

  op.create_table(
    'nvrs',
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.Column('error', sa.String(), nullable=True),
    sa.Column('alive', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('status_updated_at', sa.DateTime(), nullable=True),
    sa.Column(
      'status_data',
      postgresql.JSONB(astext_type=sa.Text()), server_default=sa.text("'{}'::jsonb"),
      nullable=False
    ),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('domain_id', sa.Integer(), nullable=True),
    sa.Column('organization_id', sa.Integer(), nullable=True),
    sa.Column('agent_id', sa.String(), nullable=True),
    sa.Column('note', sa.Text(), nullable=True),
    sa.Column('protocol', sa.String(), nullable=False),
    sa.Column(
      'settings',
      postgresql.JSONB(astext_type=sa.Text()), server_default=sa.text("'{}'::jsonb"),
      nullable=False
    ),
    sa.ForeignKeyConstraint(['domain_id'], ['domains.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['organizations.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['agent_id'], ['agents.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
  )

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  with warnings.catch_warnings():
    warnings.simplefilter("ignore", category=sa_exc.SAWarning)
    meta.reflect(bind=bind)

  cloud_streams = meta.tables['cloud_streams']
  deleted_streams = meta.tables['deleted_streams']

  agents = meta.tables['agents']

  camera_agents = session.query(
    cloud_streams.c.agent_id,
    cloud_streams.c.agent_model,
    cloud_streams.c.agent_serial,
    cloud_streams.c.agent_key,
    cloud_streams.c.registered_at,
  ).filter(
    cloud_streams.c.agent_id.isnot(None), cloud_streams.c.agent_id != ''
  )

  deleted_agents = session.query(
    deleted_streams.c.agent_id,
    deleted_streams.c.agent_model,
    deleted_streams.c.agent_serial,
    deleted_streams.c.agent_key,
    deleted_streams.c.registered_at
  ).filter(
    deleted_streams.c.agent_id.isnot(None), deleted_streams.c.agent_id != ''
  )

  agents_to_create = []
  agents_ids = set()

  for ag in camera_agents:
    if ag.agent_id in agents_ids:
      continue
    agents_to_create.append({
      agents.c.id.name: ag.agent_id,
      agents.c.model.name: ag.agent_model,
      agents.c.serial.name: ag.agent_serial,
      agents.c.key.name: ag.agent_key,
      agents.c.registered_at.name: ag.registered_at,
    })
    agents_ids.add(ag.agent_id)

  for dag in deleted_agents:
    if dag.agent_id in agents_ids:
      continue
    agents_to_create.append({
      agents.c.id.name: dag.agent_id,
      agents.c.model.name: dag.agent_model,
      agents.c.serial.name: dag.agent_serial,
      agents.c.key.name: dag.agent_key,
      agents.c.registered_at.name: dag.registered_at,
    })
    agents_ids.add(dag.agent_id)

  if agents_to_create:
    session.execute(agents.insert(), agents_to_create)
  session.commit()

  op.drop_index('ix_cloud_streams_agent_id', table_name='cloud_streams')
  op.create_foreign_key(
    'cloud_streams_agents_fkey',
    'cloud_streams', 'agents', ['agent_id'], ['id'], ondelete='SET NULL'
  )

  op.drop_column('cloud_streams', 'agent_model')
  op.drop_column('cloud_streams', 'agent_serial')
  op.drop_column('cloud_streams', 'agent_pin')
  op.drop_column('cloud_streams', 'registered_at')
  op.drop_column('cloud_streams', 'agent_key')
  op.drop_column('cloud_streams', 'dvr_protected')
  op.drop_column('cloud_streams', 'access')

  # op.drop_column('deleted_streams', 'agent_model')
  # op.drop_column('deleted_streams', 'agent_serial')
  # op.drop_column('deleted_streams', 'agent_pin')
  # op.drop_column('deleted_streams', 'agent_key')


def downgrade():
  op.drop_table('nvrs')
  op.add_column('cloud_streams', sa.Column('access', sa.VARCHAR(length=20), autoincrement=False, nullable=True))
  op.add_column('cloud_streams', sa.Column('dvr_protected', sa.BOOLEAN(), autoincrement=False, nullable=True))
  op.add_column('cloud_streams', sa.Column('agent_key', sa.VARCHAR(), autoincrement=False, nullable=True))
  op.add_column('cloud_streams', sa.Column('registered_at', sa.INTEGER(), autoincrement=False, nullable=True))
  op.add_column('cloud_streams', sa.Column('agent_pin', sa.VARCHAR(), autoincrement=False, nullable=True))
  op.add_column('cloud_streams', sa.Column('agent_serial', sa.VARCHAR(), autoincrement=False, nullable=True))
  op.add_column('cloud_streams', sa.Column('agent_model', sa.VARCHAR(), autoincrement=False, nullable=True))
  op.drop_constraint('cloud_streams_agents_fkey', 'cloud_streams', type_='foreignkey')
  op.create_index('ix_cloud_streams_agent_id', 'cloud_streams', ['agent_id'], unique=True)

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  cloud_streams = meta.tables['cloud_streams']
  agents = meta.tables['agents']

  agents_query = session.query(
    agents.c.id, agents.c.model, agents.c.serial, agents.c.key, agents.c.registered_at,
  )

  for agent in agents_query:
    agent_cam_name = session.query(cloud_streams.c.name).filter(cloud_streams.c.agent_id == agent.id).limit(1).scalar()
    if agent_cam_name:
      session.execute(cloud_streams.update().where(cloud_streams.c.name == agent_cam_name).values({
        cloud_streams.c.agent_id.name: agent.id,
        cloud_streams.c.agent_model.name: agent.model,
        cloud_streams.c.agent_serial.name: agent.serial,
        cloud_streams.c.agent_key.name: agent.key,
        cloud_streams.c.registered_at.name: agent.registered_at,
      }))

  session.commit()
  op.drop_table('agents')
