"""preset_vision_attributes

Revision ID: 9b4836c1979d
Revises: 2f5040658195
Create Date: 2021-03-24 12:01:46.800364

"""

# revision identifiers, used by Alembic.
revision = '9b4836c1979d'
down_revision = '2f5040658195'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column('presets', sa.Column('vision_alg', sa.String(), nullable=True))
  op.add_column('presets', sa.Column('vision_areas', sa.String(), nullable=True))
  op.add_column('presets', sa.Column('vision_enabled', sa.Boolean(), nullable=True))
  op.add_column('presets', sa.Column('vision_gpu', sa.Integer(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('vision', postgresql.JSONB(astext_type=sa.Text()), nullable=True))


def downgrade():
  op.drop_column('streamer_statuses', 'vision')
  op.drop_column('presets', 'vision_gpu')
  op.drop_column('presets', 'vision_enabled')
  op.drop_column('presets', 'vision_areas')
  op.drop_column('presets', 'vision_alg')
