"""face vector version added

Revision ID: 439e3b884c6b
Revises: 3c6b099e14ef
Create Date: 2021-03-10 16:16:16.161616

"""

# revision identifiers, used by Alembic.
revision = '439e3b884c6b'
down_revision = '3c6b099e14ef'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
    op.add_column('activity_persons', sa.Column('version', sa.String(), nullable=False, server_default='26750cd3'))
    op.add_column('streamer_statuses', sa.Column('vector_version', sa.String(), nullable=True))
    op.create_index('streamer_statuses_vector_version', 'streamer_statuses', ['vector_version'], unique=False)
    op.create_index('activity_persons_version', 'activity_persons', ['version'], unique=False)


def downgrade():
    op.drop_index('streamer_statuses_vector_version', table_name='streamer_statuses')
    op.drop_index('activity_persons_version', table_name='activity_persons')
    op.drop_column('streamer_statuses', 'vector_version')
    op.drop_column('activity_persons', 'version')
