"""change_stored_file_to_binary_blob

Revision ID: 3c6b099e14ef
Revises: 85647458c81e
Create Date: 2021-03-10 10:47:16.931521

"""

# revision identifiers, used by Alembic.
revision = '3c6b099e14ef'
down_revision = '85647458c81e'

import base64
import hashlib
import warnings
from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column('stored_files', sa.Column('binary_content', sa.LargeBinary(), nullable=True))

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  with warnings.catch_warnings():
    warnings.simplefilter("ignore", category=sa.exc.SAWarning)
    meta.reflect(bind=bind)

  stored_files = meta.tables['stored_files']

  stored_files_query = session.execute(
    sa.select([
      stored_files.c.path,
      stored_files.c.b64_content
    ])
  )

  for path, b64_content in stored_files_query:
    binary_content = base64.b64decode(b64_content)
    etag = hashlib.sha1(binary_content).hexdigest()
    session.execute(
      stored_files.update().values(
        binary_content=binary_content,
        etag=etag
      ).where(
        stored_files.c.path == path
      )
    )
  session.commit()
  op.drop_column('stored_files', 'b64_content')
  op.alter_column(table_name='stored_files', column_name='binary_content', nullable=False)


def downgrade():
  op.add_column('stored_files', sa.Column('b64_content', sa.Text(), nullable=True))
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  stored_files = meta.tables['stored_files']

  stored_files_query = session.execute(
    sa.select([
      stored_files.c.path,
      stored_files.c.binary_content
    ])
  )

  for path, binary_content in stored_files_query:
    b64_content = base64.b64encode(binary_content)
    etag = hashlib.sha1(binary_content).hexdigest()

    session.execute(
      stored_files.update().values(
        b64_content=b64_content.decode('utf-8'),
        etag=etag
      ).where(
        stored_files.c.path == path
      )
    )
  session.commit()
  op.drop_column('stored_files', 'binary_content')
  op.alter_column(table_name='stored_files', column_name='b64_content', nullable=False)
