"""add_streamer_status_config_fields

Revision ID: 85647458c81e
Revises: 54cf96d2d9d6
Create Date: 2021-02-15 07:21:26.436938

"""

# revision identifiers, used by Alembic.
revision = '85647458c81e'
down_revision = '54cf96d2d9d6'

import warnings
from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from watcher import utils


def upgrade():
  op.add_column('streamer_statuses', sa.Column('cluster_key', sa.String(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('dvrs', postgresql.JSONB(astext_type=sa.Text()), nullable=True))
  op.add_column('streamer_statuses', sa.Column('is_remote', sa.Boolean(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('port_https', postgresql.JSONB(astext_type=sa.Text()), nullable=True))
  op.add_column('streamer_statuses', sa.Column('port_rtmp', sa.Integer(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('port_rtsp', sa.Integer(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('rproxy_auth', sa.String(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('rproxy_forward_port', sa.Integer(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('rproxy_streampoint_key', sa.String(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('server_id', sa.String(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('vsaas_auth_backend_url', sa.String(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('vsaas_auth_backend_url_reachable', sa.Boolean(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('vsaas_endpoint', sa.String(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('vsaas_event_sink', sa.String(), nullable=True))
  op.add_column('streamer_statuses', sa.Column('vsaas_events', postgresql.JSONB(astext_type=sa.Text()), nullable=True))
  op.add_column('streamers', sa.Column('streampoint_key', sa.String(), nullable=True))

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  with warnings.catch_warnings():
    warnings.simplefilter("ignore", category=sa.exc.SAWarning)
    meta.reflect(bind=bind)

  straeamers = meta.tables['streamers']
  streampoint_key = utils.rand_str(10)
  session.execute(
    straeamers.update().values(streampoint_key=streampoint_key)
  )
  session.commit()

  op.alter_column(
    table_name='streamers',
    column_name='streampoint_key',
    nullable=False
  )


def downgrade():
  op.drop_column('streamer_statuses', 'vsaas_events')
  op.drop_column('streamer_statuses', 'vsaas_event_sink')
  op.drop_column('streamer_statuses', 'vsaas_endpoint')
  op.drop_column('streamer_statuses', 'vsaas_auth_backend_url')
  op.drop_column('streamer_statuses', 'server_id')
  op.drop_column('streamer_statuses', 'rproxy_streampoint_key')
  op.drop_column('streamer_statuses', 'rproxy_forward_port')
  op.drop_column('streamer_statuses', 'rproxy_auth')
  op.drop_column('streamer_statuses', 'port_rtsp')
  op.drop_column('streamer_statuses', 'port_rtmp')
  op.drop_column('streamer_statuses', 'port_https')
  op.drop_column('streamer_statuses', 'is_remote')
  op.drop_column('streamer_statuses', 'dvrs')
  op.drop_column('streamer_statuses', 'cluster_key')
  op.drop_column('streamer_statuses', 'vsaas_auth_backend_url_reachable')

  op.drop_column('streamers', 'streampoint_key')
