"""add_streamer_dvr_config

Revision ID: 89303c5b7347
Revises: 04dc68472ca6
Create Date: 2020-11-12 15:25:21.308076

"""

# revision identifiers, used by Alembic.
revision = '89303c5b7347'
down_revision = '04dc68472ca6'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column(
    'streamers',
    sa.Column(
      'dvr_config',
      postgresql.JSONB(astext_type=sa.Text()), server_default=sa.text("'{}'::jsonb"),
      nullable=False
    )
  )
  op.add_column(
    'streamers',
    sa.Column(
      'vision_config',
      postgresql.JSONB(astext_type=sa.Text()), server_default=sa.text("'{}'::jsonb"),
      nullable=False
    )
  )


def downgrade():
  op.drop_column('streamers', 'dvr_config')
  op.drop_column('streamers', 'vision_config')
