"""domain id added for analytics

Revision ID: 04dc68472ca6
Revises: ccba469705ac
Create Date: 2020-11-30 15:00:00.014740

"""

# revision identifiers, used by Alembic.
revision = '04dc68472ca6'
down_revision = 'ccba469705ac'

import warnings
from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from sqlalchemy.schema import MetaData


def upgrade():
    bind = op.get_bind()
    session = sa.orm.Session(bind=bind)

    meta = MetaData()
    with warnings.catch_warnings():
        warnings.simplefilter("ignore", category=sa.exc.SAWarning)
        meta.reflect(bind=bind)
    domain_table = meta.tables['domains']
    (default_domain_id, ) = session.execute(
        sa.select([domain_table.c.id]).where(domain_table.c.is_default.is_(True))
    ).fetchone() or None

    op.add_column(
        'activity_cars',
        sa.Column('domain_id', sa.Integer(), nullable=False, server_default=f'{default_domain_id}'))
    op.add_column(
        'activity_faces',
        sa.Column('domain_id', sa.Integer(), nullable=False, server_default=f'{default_domain_id}'))
    op.add_column(
        'activity_persons',
        sa.Column('domain_id', sa.Integer(), nullable=False, server_default=f'{default_domain_id}'))
    op.add_column(
        'car_list',
        sa.Column('domain_id', sa.Integer(), nullable=False, server_default=f'{default_domain_id}'))
    op.add_column(
        'license_plates',
        sa.Column('domain_id', sa.Integer(), nullable=False, server_default=f'{default_domain_id}'))
    op.add_column(
        'person_category',
        sa.Column('domain_id', sa.Integer(), nullable=False, server_default=f'{default_domain_id}'))
    op.add_column(
        'person_list',
        sa.Column('domain_id', sa.Integer(), nullable=False, server_default=f'{default_domain_id}'))

    op.create_foreign_key(None, 'activity_cars', 'domains', ['domain_id'], ['id'])
    op.create_foreign_key(None, 'activity_faces', 'domains', ['domain_id'], ['id'])
    op.create_foreign_key(None, 'activity_persons', 'domains', ['domain_id'], ['id'])
    op.create_foreign_key(None, 'car_list', 'domains', ['domain_id'], ['id'])
    op.create_foreign_key(None, 'license_plates', 'domains', ['domain_id'], ['id'])
    op.create_foreign_key(None, 'person_category', 'domains', ['domain_id'], ['id'])
    op.create_foreign_key(None, 'person_list', 'domains', ['domain_id'], ['id'])

    op.alter_column('activity_cars', 'domain_id', server_default=sa.null())
    op.alter_column('activity_faces', 'domain_id', server_default=sa.null())
    op.alter_column('activity_persons', 'domain_id', server_default=sa.null())
    op.alter_column('car_list', 'domain_id', server_default=sa.null())
    op.alter_column('license_plates', 'domain_id', server_default=sa.null())
    op.alter_column('person_category', 'domain_id', server_default=sa.null())
    op.alter_column('person_list', 'domain_id', server_default=sa.null())
    session.commit()
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('person_list', 'domain_id')
    op.drop_column('person_category', 'domain_id')
    op.drop_column('license_plates', 'domain_id')
    op.drop_column('car_list', 'domain_id')
    op.drop_column('activity_persons', 'domain_id')
    op.drop_column('activity_faces', 'domain_id')
    op.drop_column('activity_cars', 'domain_id')
    # ### end Alembic commands ###
