"""stream_status_last_event_data_last_change_data

Revision ID: 4d7f641b9095
Revises: d792a8ead1c0
Create Date: 2020-10-29 15:37:51.136177

"""

# revision identifiers, used by Alembic.
revision = '4d7f641b9095'
down_revision = 'd792a8ead1c0'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from datetime import datetime


def upgrade():
  op.add_column(
    'stream_statuses',
    sa.Column(
      'last_change_data',
      postgresql.JSONB(astext_type=sa.Text()),
      server_default=sa.text("'{}'::jsonb"),
      nullable=False
    )
  )
  op.add_column(
    'stream_statuses',
    sa.Column(
      'last_event_data',
      postgresql.JSONB(astext_type=sa.Text()),
      server_default=sa.text("'{}'::jsonb"),
      nullable=False
    )
  )

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  from watcher.models import Event, LogEntry, CloudStream

  stream_statuses_map = {}

  last_events_q = session.query(
    Event.camera_id,
    sa.func.max(Event.start_at).label('start_at')
  ).filter(
    Event.camera_id.in_(session.query(CloudStream.name))
  ).group_by(Event.camera_id)

  stream_status_defaults = {
    'alive': False,
    'created_at': datetime.utcnow(),
    'updated_at': datetime.utcnow(),
  }

  for cam_id, event_start_at in last_events_q:
    stream_statuses_map[cam_id] = {
      'camera_id': cam_id,
      'last_event_data': {'start_at': event_start_at},
      'last_change_data': {},
      **stream_status_defaults
    }

  log_entries_q = session.query(LogEntry.object_id, LogEntry.user, LogEntry.created_at).filter(
    LogEntry.object_type == 'Camera',
    LogEntry.action_type == LogEntry.action_types.change,
    LogEntry.object_id.in_(session.query(CloudStream.name))
  ).order_by(
    LogEntry.object_id, LogEntry.created_at
  ).distinct(LogEntry.object_id)

  for cam_id, user, log_entry_created_at in log_entries_q:
    stream_status_data = stream_statuses_map.get(
      cam_id, {'camera_id': cam_id, 'last_event_data': {}, **stream_status_defaults}
    )
    stream_status_data['last_change_data'] = {
      'user': user,
      'object_id': cam_id,
      'created_at': log_entry_created_at
    }
    stream_statuses_map[cam_id] = stream_status_data

  stream_statuses_table = meta.tables['stream_statuses']
  if stream_statuses_map:
    session.execute(
      stream_statuses_table.delete()
    )
    session.execute(
      postgresql
      .insert(stream_statuses_table)
      .values([val for val in stream_statuses_map.values()])
    )
    session.commit()


def downgrade():
  op.drop_column('stream_statuses', 'last_event_data')
  op.drop_column('stream_statuses', 'last_change_data')
