"""add_agent_status

Revision ID: d792a8ead1c0
Revises: e829fc47ab53
Create Date: 2020-11-09 16:42:59.895734

"""

# revision identifiers, used by Alembic.
revision = 'd792a8ead1c0'
down_revision = 'e829fc47ab53'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
      'agent_statuses',
      sa.Column('agent_id', sa.Text(), nullable=False),
      sa.Column('created_at', sa.DateTime(), nullable=False),
      sa.Column('updated_at', sa.DateTime(), nullable=False),
      sa.Column('connected_to_endpoint', sa.Boolean(), server_default=sa.text('false'), nullable=False),
      sa.Column('connected_to_streampoint', sa.Boolean(), server_default=sa.text('false'), nullable=False),
      sa.Column(
        'endpoint_agent_info',
        postgresql.JSONB(astext_type=sa.Text()), server_default=sa.text("'{}'::jsonb"), nullable=False
      ),
      sa.Column('endpoint_status_changed_at', sa.Integer(), nullable=True),
      sa.Column(
        'streampoint_agent_info',
        postgresql.JSONB(astext_type=sa.Text()), server_default=sa.text("'{}'::jsonb"), nullable=False
      ),
      sa.Column('streampoint_status_changed_at', sa.Integer(), nullable=True),
      sa.PrimaryKeyConstraint('agent_id')
    )


def downgrade():
  op.drop_table('agent_statuses')
