"""dvr_depth_to_float

Revision ID: 5e4e6f7c8573
Revises: a1ecd76da5e8
Create Date: 2020-07-17 11:45:45.772899

"""

# revision identifiers, used by Alembic.
revision = '5e4e6f7c8573'
down_revision = 'a1ecd76da5e8'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.alter_column(
    'cloud_streams', 'dvr_depth',
    existing_type=sa.INTEGER(),
    type_=sa.Float(),
    existing_nullable=True
  )

  op.alter_column(
    'presets', 'dvr_depth',
    existing_type=sa.INTEGER(),
    type_=sa.Float(),
    existing_nullable=True
  )


def downgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  cloud_streams_table = meta.tables['cloud_streams']
  presets_table = meta.tables['presets']

  session.execute(
    cloud_streams_table.update().where(
      cloud_streams_table.c.dvr_depth < 1
    ).values(dvr_depth=1)
  )
  session.execute(
    presets_table.update().where(
      presets_table.c.dvr_depth < 1
    ).values(dvr_depth=1)
  )
  session.commit()

  op.alter_column(
    'cloud_streams', 'dvr_depth',
    existing_type=sa.Float(),
    type_=sa.INTEGER(),
    existing_nullable=True
  )

  op.alter_column(
    'presets', 'dvr_depth',
    existing_type=sa.Float(),
    type_=sa.INTEGER(),
    existing_nullable=True
  )
