"""user_readonly_field

Revision ID: dad763f2dc9a
Revises: v20.07
Create Date: 2020-07-06 12:58:21.417359

"""

# revision identifiers, used by Alembic.
revision = 'dad763f2dc9a'
down_revision = 'v20.07'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column('users', sa.Column('readonly', sa.Boolean(), nullable=False, server_default=sa.false()))

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  users_table = meta.tables['users']
  session.execute(
    users_table.update().where(
      users_table.c.email == 'demo'
    ).values(readonly=True)
  )
  session.commit()


def downgrade():
  op.drop_column('users', 'readonly')
