"""create faces and persons

Revision ID: 9955e21bb2e6
Revises: 0f72327f2dc8
Create Date: 2020-05-14 00:47:03.054331

"""

# revision identifiers, used by Alembic.
revision = '9955e21bb2e6'
down_revision = '0f72327f2dc8'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402


def upgrade():
  op.create_table(
    'person_list',
    sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('data', sa.JSON(), nullable=False, default='{}'),

    sa.PrimaryKeyConstraint('id')
  )
  op.create_index('person_list_id', 'person_list', ['id'], unique=True)

  op.create_table(
    'camera_person_list_association',
    sa.Column('camera_id', sa.String(), nullable=False, unique=True),
    sa.Column('person_list_id', sa.Integer(), nullable=False)
  )
  op.create_index('camera_person_list_association_cam_id', 'camera_person_list_association',
                  ['camera_id'], unique=True)

  op.create_table(
    'person_category',
    sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
    sa.Column('name', sa.String(), nullable=False, default=''),

    sa.PrimaryKeyConstraint('id')
  )
  op.create_index('person_category_id', 'person_category', ['id'], unique=True)

  op.create_table(
    'activity_persons',
    sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
    sa.Column('note', sa.Text(), nullable=True),
    sa.Column('vector', sa.LargeBinary(), nullable=False),
    sa.Column('preview', sa.LargeBinary(), nullable=True),
    sa.Column('has_preview', sa.Boolean(), nullable=False, default=False),

    sa.Column('name', sa.String(), nullable=True, default=''),
    sa.Column('last_seen_at', sa.DateTime(timezone=True), nullable=False, default=sa.sql.func.now()),
    sa.Column('first_seen_at', sa.DateTime(timezone=True), nullable=False, default=sa.sql.func.now()),

    sa.Column('person_list_id', sa.Integer(), nullable=True),
    sa.Column('person_category_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['person_list_id'], ['person_list.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['person_category_id'], ['person_category.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
  )
  op.create_index('activity_persons_last_seen_at', 'activity_persons', ['last_seen_at'], unique=False)

  op.create_table(
    'activity_faces',
    sa.Column('id', sa.Integer(), nullable=False, autoincrement=True),
    sa.Column('event_id', sa.String(), nullable=False),  # For back compatibility
    sa.Column('camera_id', sa.String(), nullable=False),
    sa.Column('person_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['camera_id'], ['cloud_streams.name'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['person_id'], ['activity_persons.id'], ondelete='CASCADE'),

    sa.Column('start_at', sa.DateTime(timezone=True), nullable=False),
    sa.Column('end_at', sa.DateTime(timezone=True), nullable=False),
    sa.Column('area_id', sa.Integer(), nullable=False, default=-1),
    sa.Column('vector', sa.LargeBinary(), nullable=False),
    sa.Column('preview', sa.LargeBinary(), nullable=True),

    sa.Column('radius', sa.Float(), nullable=False, default=0.0),
    sa.Column('weight', sa.Integer(), nullable=False, default=0),

    sa.PrimaryKeyConstraint('id')
  )
  op.create_index('activity_faces_end_at', 'activity_faces', ['end_at'], unique=False)
  op.create_index('activity_faces_event_id', 'activity_faces', ['event_id'], unique=True)

  op.add_column('event_subscriptions', sa.Column('notify_url', sa.Text(), nullable=True))


def downgrade():
  op.drop_table('camera_person_list_association')
  op.drop_column('event_subscriptions', 'notify_url')
  op.drop_table('activity_faces')
  op.drop_table('activity_persons')
  op.drop_table('person_list')
  op.drop_table('person_category')
