"""add_folder_maps

Revision ID: 0f72327f2dc8
Revises: v20.06
Create Date: 2020-06-09 16:13:58.161509

"""

# revision identifiers, used by Alembic.
revision = '0f72327f2dc8'
down_revision = 'v20.06'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from watcher.models import StoredFile  # noqa: F402


def upgrade():
  op.add_column('folders', sa.Column('coordinates', sa.Text(), nullable=True))
  op.add_column('folders', sa.Column('map_topleft', sa.Text(), nullable=True))
  op.add_column('folders', sa.Column('map_topright', sa.Text(), nullable=True))
  op.add_column('folders', sa.Column('map_bottomleft', sa.Text(), nullable=True))

  op.add_column('cloud_streams', sa.Column('folder_coordinates', sa.Text(), nullable=True))
  op.drop_column('folders', 'lft')
  op.drop_column('folders', 'tree_id')
  op.drop_column('folders', 'level')
  op.drop_column('folders', 'rgt')

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)
  stored_files = meta.tables['stored_files']

  for sf in session.execute(stored_files.select()):
    old_path = sf.path
    domain_id, filename = old_path.split('-', 1)
    if filename in ['custom-logo', 'custom-auth-logo', 'custom-favicon']:
      filename2 = filename.replace('-', '_')

      newpath = StoredFile.branding_path(domain_id, filename2)

      session.execute(
        stored_files.update().where(
          stored_files.c.path == old_path
        ).values(path=newpath))
  session.commit()


def downgrade():
  op.add_column(
    'folders',
    sa.Column('rgt', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False)
  )
  op.add_column(
    'folders',
    sa.Column('level', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False)
  )
  op.add_column(
    'folders',
    sa.Column('tree_id', sa.INTEGER(), autoincrement=False, nullable=True)
  )
  op.add_column(
    'folders',
    sa.Column('lft', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False)
  )
  op.drop_column('folders', 'coordinates')
  op.drop_column('folders', 'map_topleft')
  op.drop_column('folders', 'map_topright')
  op.drop_column('folders', 'map_bottomleft')

  op.drop_column('cloud_streams', 'folder_coordinates')

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)
  stored_files = meta.tables['stored_files']

  branding_fileses = session.execute(
    stored_files.select().where(stored_files.c.path.like('%-branding-%'))
  )
  for sf in branding_fileses:
    old_path = sf.path
    domain_id, filename = old_path.split('-branding-')
    filename2 = filename.replace('_', '-')
    newpath = f'{domain_id}-{filename2}'
    session.execute(
      stored_files.update().where(
        stored_files.c.path == old_path
      ).values(path=newpath))
  session.commit()
