"""fix_domain_settings_bools

Revision ID: 3f7e2d226eea
Revises: c62184230f35
Create Date: 2020-02-04 16:16:59.140821

"""

# revision identifiers, used by Alembic.
revision = '3f7e2d226eea'
down_revision = 'c62184230f35'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from watcher.models import Domain  # noqa: F402
from watcher.utils import strtobool   # noqa: F402


def upgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)

  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  domains = meta.tables['domains']

  fiedls_to_fix = [
    'global_anonymous_access',
    'global_serial_binding_enabled',
    'global_allow_registration',
    'global_demo_access',
    'peeklio_disable_notifications',
    'map_show_in_nav'
  ]
  fields_to_delete = [
    'global_use_v1_ui',
    'global_inital_configured',
    'global_experimental_dashboard'
  ]

  for domain_id, domain_settings in session.query(Domain.id, Domain.settings).all():
    domain_settings = domain_settings or {}
    for ftd in fields_to_delete:
      domain_settings.pop(ftd, None)

    for ftf in fiedls_to_fix:
      value = domain_settings.get(ftf)
      if value and isinstance(value, str):
        try:
          domain_settings[ftf] = strtobool(value)
        except ValueError:
          domain_settings[ftf] = False

    session.execute(domains.update().where(
      domains.c.id == domain_id).values({'settings': domain_settings})
    )


def downgrade():
  pass
