"""add_cloud_stream_extra_config

Revision ID: c62184230f35
Revises: v20.01
Create Date: 2020-01-30 14:20:56.457352

"""

# revision identifiers, used by Alembic.
revision = 'c62184230f35'
down_revision = 'v20.01'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column(
    'cloud_streams',
    sa.Column(
      'extra_config',
      postgresql.JSONB(astext_type=sa.Text()),
      server_default=sa.text("'{}'::jsonb"),
      nullable=False
    )
  )


def downgrade():
  op.drop_column('cloud_streams', 'extra_config')
