"""remove camera.server fk

Revision ID: 64b722d22ee8
Revises: 86c1d39f0da7
Create Date: 2019-12-30 12:42:32.032919

"""

# revision identifiers, used by Alembic.
revision = '64b722d22ee8'
down_revision = '86c1d39f0da7'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402


def upgrade():
  op.drop_constraint('cloud_streams_server_fkey', 'cloud_streams', type_='foreignkey')
  op.drop_column('cloud_streams', 'server')


def downgrade():
  op.add_column('cloud_streams', sa.Column('server', sa.String(), nullable=True))
  op.create_foreign_key(
    'cloud_streams_server_fkey',
    'cloud_streams', 'streamers',
    ['server'], ['host'],
    ondelete='SET NULL')
