"""add_streamer_code

Revision ID: fb84c86c5b02
Revises: v19.12
Create Date: 2019-12-10 16:00:10.212256

"""

# revision identifiers, used by Alembic.
revision = 'fb84c86c5b02'
down_revision = 'v19.12'


from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from watcher.models.streamer import Streamer  # noqa: F402
from watcher.utils import uuid4   # noqa: F402


def upgrade():
  op.add_column('streamers', sa.Column('code', sa.String(length=36), nullable=True))

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)
  streamers = meta.tables['streamers']

  for streamer in session.execute(streamers.select()):
    code = uuid4()

    session.execute(
      streamers.update()
      .where(streamers.c.id == streamer.id)
      .values(code=code)
    )

  session.commit()

  op.alter_column(
    'streamers', 'code',
    existing_type=sa.VARCHAR(length=36),
    nullable=False)
  op.create_unique_constraint('streamers_code_uc', 'streamers', ['code'])


def downgrade():
  op.drop_constraint('streamers_code_uc', 'streamers', type_='unique')
  op.drop_column('streamers', 'code')
