"""create table worker_tasks

Revision ID: f07d9801dc97
Revises: d7e1d0f753dd
Create Date: 2019-11-27 15:16:20.799018

"""

# revision identifiers, used by Alembic.
revision = 'f07d9801dc97'
down_revision = 'd7e1d0f753dd'

import sqlalchemy as sa  # noqa: F402
from alembic import op  # noqa: F402


def upgrade():
  op.create_table(
    'worker_tasks',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('queue', sa.String(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
    sa.Column('payload', sa.Text(), nullable=False),
    sa.PrimaryKeyConstraint('id')
  )
  op.create_index('ix_worker_tasks_queue', 'worker_tasks', ['queue'], unique=False)


def downgrade():
  op.drop_index('ix_worker_tasks_queue', table_name='worker_tasks')
  op.drop_table('worker_tasks')
