"""fix_json_fields

Revision ID: 8e329c18646b
Revises: db832a4892c8
Create Date: 2019-10-22 11:04:14.547566

"""

# revision identifiers, used by Alembic.
revision = '8e329c18646b'
down_revision = 'db832a4892c8'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from sqlalchemy import orm  # noqa: F402
from sqlalchemy import inspect  # noqa: F402


def fix_existing():
  bind = op.get_bind()
  session = orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  users = meta.tables['users']
  session.execute(
    users.update().where(users.c.user_settings.is_(None)).values(user_settings={})
  )
  session.execute(
    users.update().where(users.c.permissions.is_(None)).values(permissions={})
  )

  domains = meta.tables['domains']
  session.execute(
    domains.update().where(domains.c.settings.is_(None)).values(settings={})
  )

  log_entries = meta.tables['log_entries']
  session.execute(
    log_entries.update().where(log_entries.c.event_data.is_(None)).values(event_data={})
  )
  session.execute(
    log_entries.update().where(log_entries.c.request_data.is_(None)).values(request_data={})
  )

  events = meta.tables['events']
  session.execute(
    events.update().where(events.c.event_data.is_(None)).values(event_data={})
  )
  session.execute(
    events.update().where(events.c.ext_data.is_(None)).values(ext_data={})
  )

  presets = meta.tables['presets']
  session.execute(
    presets.update().where(presets.c.vision_params.is_(None)).values(vision_params={})
  )

  session.commit()


def upgrade():
  fix_existing()

  op.alter_column(
    table_name='users',
    column_name='permissions',
    server_default=sa.text("'{}'::jsonb"),
    nullable=False
  )

  op.alter_column(
    table_name='users',
    column_name='user_settings',
    existing_type=postgresql.JSON(astext_type=sa.Text()),
    type_=postgresql.JSONB(astext_type=sa.Text()),
    postgresql_using='user_settings',
    nullable=False,
    server_default=sa.text("'{}'::jsonb"),
  )

  op.alter_column(
    table_name='domains',
    column_name='settings',
    existing_type=postgresql.JSON(astext_type=sa.Text()),
    type_=postgresql.JSONB(astext_type=sa.Text()),
    postgresql_using='settings',
    nullable=False,
    server_default=sa.text("'{}'::jsonb"),
  )

  op.alter_column(
    table_name='log_entries',
    column_name='event_data',
    existing_type=postgresql.JSON(astext_type=sa.Text()),
    type_=postgresql.JSONB(astext_type=sa.Text()),
    postgresql_using='event_data',
    nullable=False,
    server_default=sa.text("'{}'::jsonb"),
  )

  op.alter_column(
    table_name='log_entries',
    column_name='request_data',
    existing_type=postgresql.JSON(astext_type=sa.Text()),
    type_=postgresql.JSONB(astext_type=sa.Text()),
    postgresql_using='request_data',
    nullable=False,
    server_default=sa.text("'{}'::jsonb"),
  )

  op.alter_column(
    table_name='events',
    column_name='event_data',
    existing_type=postgresql.JSON(astext_type=sa.Text()),
    type_=postgresql.JSONB(astext_type=sa.Text()),
    postgresql_using='event_data',
    nullable=False,
    server_default=sa.text("'{}'::jsonb"),
  )

  op.alter_column(
    table_name='events',
    column_name='ext_data',
    existing_type=postgresql.JSON(astext_type=sa.Text()),
    type_=postgresql.JSONB(astext_type=sa.Text()),
    postgresql_using='ext_data',
    nullable=False,
    server_default=sa.text("'{}'::jsonb"),
  )

  op.alter_column(
    table_name='presets',
    column_name='vision_params',
    existing_type=postgresql.JSON(astext_type=sa.Text()),
    type_=postgresql.JSONB(astext_type=sa.Text()),
    postgresql_using='vision_params',
    nullable=False,
    server_default=sa.text("'{}'::jsonb"),
  )


def downgrade():
  op.alter_column(
    table_name='users',
    column_name='permissions',
    server_default=sa.text("'{}'::jsonb"),
    nullable=True
  )

  op.alter_column(
    table_name='users',
    column_name='user_settings',
    existing_type=postgresql.JSONB(astext_type=sa.Text()),
    type_=postgresql.JSON(astext_type=sa.Text()),
    postgresql_using='user_settings',
    nullable=True,
    server_default=sa.text("'{}'::json"),
  )

  op.alter_column(
    table_name='domains',
    column_name='settings',
    existing_type=postgresql.JSONB(astext_type=sa.Text()),
    type_=postgresql.JSON(astext_type=sa.Text()),
    postgresql_using='settings',
    nullable=True,
    server_default=sa.text("'{}'::json"),
  )

  op.alter_column(
    table_name='log_entries',
    column_name='event_data',
    existing_type=postgresql.JSONB(astext_type=sa.Text()),
    type_=postgresql.JSON(astext_type=sa.Text()),
    postgresql_using='event_data',
    nullable=True,
    server_default=sa.text("'{}'::json"),
  )

  op.alter_column(
    table_name='log_entries',
    column_name='request_data',
    existing_type=postgresql.JSONB(astext_type=sa.Text()),
    type_=postgresql.JSON(astext_type=sa.Text()),
    postgresql_using='request_data',
    nullable=True,
    server_default=sa.text("'{}'::jsonb"),
  )

  op.alter_column(
    table_name='events',
    column_name='event_data',
    existing_type=postgresql.JSONB(astext_type=sa.Text()),
    type_=postgresql.JSON(astext_type=sa.Text()),
    postgresql_using='event_data',
    nullable=True,
    server_default=sa.text("'{}'::json"),
  )

  op.alter_column(
    table_name='events',
    column_name='ext_data',
    existing_type=postgresql.JSONB(astext_type=sa.Text()),
    type_=postgresql.JSON(astext_type=sa.Text()),
    postgresql_using='ext_data',
    nullable=True,
    server_default=sa.text("'{}'::json"),
  )

  op.alter_column(
    table_name='presets',
    column_name='vision_params',
    existing_type=postgresql.JSONB(astext_type=sa.Text()),
    type_=postgresql.JSON(astext_type=sa.Text()),
    postgresql_using='vision_params',
    nullable=True,
    server_default=sa.text("'{}'::json"),
  )
