"""mosaics_to_organization

Revision ID: db832a4892c8
Revises: bb52cbd644f3
Create Date: 2019-10-17 14:34:11.035943

"""

# revision identifiers, used by Alembic.
revision = 'db832a4892c8'
down_revision = 'bb52cbd644f3'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy import orm  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from sqlalchemy.schema import MetaData  # noqa: F402
from watcher.utils import IndexedList  # noqa: F402


def upgrade():
  op.create_table(
    'mosaic_cameras',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('mosaic_id', sa.Integer(), nullable=False),
    sa.Column('camera_id', sa.Text(), nullable=False),
    sa.Column('order_num', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['camera_id'], ['cloud_streams.name'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['mosaic_id'], ['mosaics.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sqlite_autoincrement=True
  )
  op.create_index('mosaic_camera', 'mosaic_cameras', ['mosaic_id', 'camera_id'], unique=True)
  op.create_index('mosaic_camera_order', 'mosaic_cameras', ['mosaic_id', 'order_num'], unique=True)
  op.add_column('mosaics', sa.Column('organization_id', sa.Integer(), nullable=True))
  op.create_foreign_key(
      'mosaics_organization', 'mosaics', 'organizations', ['organization_id'], ['id'],
      ondelete='SET NULL'
  )

  bind = op.get_bind()
  session = orm.Session(bind=bind)

  meta = MetaData()
  meta.reflect(bind=bind)

  cloud_streams = meta.tables['cloud_streams']
  mosaics = meta.tables['mosaics']
  domains = meta.tables['domains']
  organizations = meta.tables['organizations']

  default_domain = session.execute(domains.select().where(domains.c.is_default.is_(True))).fetchone()
  default_org_id = default_domain.settings.get('default_organization_id')
  default_organization = session.execute(
    organizations.select().where(organizations.c.id == default_org_id)).fetchone()

  mosaics_cameras_to_create = []

  session.execute(mosaics.update().values(organization_id=default_organization.id))

  for mosaic in session.execute(mosaics.select()):
    mosaics_cameras = list(set(mosaic.cameras.split(" ")))
    for i, camera_name in enumerate(mosaics_cameras):
      if camera_name:
        camera = session.execute(
          cloud_streams.select().where(cloud_streams.c.name == camera_name)
        ).fetchone()
        if camera:
          mosaics_cameras_to_create.append({
            'mosaic_id': mosaic.id,
            'camera_id': camera.name,
            'order_num': i
          })

  if mosaics_cameras_to_create:
    mosaic_cameras = meta.tables['mosaic_cameras']
    session.execute(
      mosaic_cameras.insert().values(mosaics_cameras_to_create)
    )
  session.commit()
  op.drop_column('mosaics', 'cameras')


def downgrade():
  op.add_column('mosaics', sa.Column('cameras', sa.VARCHAR(), default='', autoincrement=False, nullable=True))

  bind = op.get_bind()
  session = orm.Session(bind=bind)

  meta = MetaData()
  meta.reflect(bind=bind)

  mosaics = meta.tables['mosaics']
  mosaic_cameras = meta.tables['mosaic_cameras']
  for mosaic in session.execute(mosaics.select()):
    cams_by_type = {'2x2': 4, '3x3': 9, '4x4': 16, '1x7': 7}
    cams_count = cams_by_type[mosaic.type]

    cameras_names = []
    mcs = IndexedList(session.execute(
      mosaic_cameras.select().where(
        mosaic_cameras.c.mosaic_id == mosaic.id
      ).order_by(mosaic_cameras.c.order_num)
    ), index_by=['order_num', ])
    for i in range(cams_count):
      mc = mcs.get_one_by('order_num', i)
      camera_name = mc.camera_id if mc else ''
      cameras_names.append(camera_name)

    cameras = " ".join(cameras_names)
    session.execute(
      mosaics.update().values(cameras=cameras).where(mosaics.c.id == mosaic.id)
    )

  op.drop_constraint('mosaics_organization', 'mosaics', type_='foreignkey')
  op.drop_column('mosaics', 'organization_id')
  op.drop_index('mosaic_camera_order', table_name='mosaic_cameras')
  op.drop_index('mosaic_camera', table_name='mosaic_cameras')
  op.drop_table('mosaic_cameras')
  # ### end Alembic commands ###
