"""cloud_stream:motion_detector

Revision ID: 8af56a6ddd78
Revises: 75db211c25da
Create Date: 2019-10-08 17:56:48.911055

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '8af56a6ddd78'
down_revision = '75db211c25da'


def upgrade():
  op.add_column(
    'cloud_streams',
    sa.Column(
      'motion_detector_enabled', sa.Boolean(),
      nullable=False, server_default=sa.sql.false()))

  op.add_column(
    'cloud_streams',
    sa.Column(
      'motion_detector_settings', sa.dialects.postgresql.JSONB(),
      nullable=False, server_default='{}'))

  op.create_index(
    op.f('ix_cloud_streams_motion_detector_enabled'),
    'cloud_streams', ['motion_detector_enabled'],
    unique=False)


def downgrade():
  op.drop_index(op.f('ix_cloud_streams_motion_detector_enabled'), table_name='cloud_streams')
  op.drop_column('cloud_streams', 'motion_detector_enabled')
  op.drop_column('cloud_streams', 'motion_detector_settings')
