"""extend_messages

Revision ID: b8129f2524cd
Revises: 92af0e136265
Create Date: 2019-09-03 15:16:35.250749

"""

# revision identifiers, used by Alembic.
revision = 'b8129f2524cd'
down_revision = '92af0e136265'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
    op.add_column('watcher_messages', sa.Column('title', sa.String(), nullable=False, server_default=''))
    op.add_column('watcher_messages', sa.Column('sender_id', sa.Integer(), nullable=True))
    op.add_column('watcher_messages', sa.Column('is_dashboard', sa.Boolean(), server_default=sa.schema.DefaultClause("0"), nullable=False))
    op.add_column('watcher_messages', sa.Column('is_push', sa.Boolean(), server_default=sa.schema.DefaultClause("0"), nullable=False))
    op.add_column('watcher_messages', sa.Column('was_read', sa.Boolean(), server_default=sa.schema.DefaultClause("0"), nullable=False))
    op.add_column('watcher_messages', sa.Column('is_deleted', sa.Boolean(), server_default=sa.schema.DefaultClause("0"), nullable=False))
    op.create_foreign_key('fk_message_sender', 'watcher_messages', 'users', ['sender_id'], ['id'])


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('fk_message_sender', 'watcher_messages', type_='foreignkey')
    op.drop_column('watcher_messages', 'was_read')
    op.drop_column('watcher_messages', 'sender_id')
    op.drop_column('watcher_messages', 'is_push')
    op.drop_column('watcher_messages', 'is_dashboard')
    op.drop_column('watcher_messages', 'is_deleted')
    op.drop_column('watcher_messages', 'title')
