"""migrate_mail_settings

Revision ID: 1cbcb081688a
Revises: v19.08
Create Date: 2019-08-01 13:31:04.316398

"""

# revision identifiers, used by Alembic.
revision = '1cbcb081688a'
down_revision = 'v19.08'

import os
from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm
from sqlalchemy import inspect
from sqlalchemy.orm.attributes import flag_modified
from watcher.models import Domain


def upgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)

  domains = Domain.__table__

  default_domain_id, default_domain_settings = session.execute(
    sa.select([domains.c.id, domains.c.settings]).where(domains.c.is_default.is_(True))
  ).fetchone() or (None, {})

  default_domain_settings = default_domain_settings or {}

  mail_from = os.environ.get('EMAIL_FROM')

  tls = os.environ.get('MAIL_USE_TLS') in [1, 'true']
  ssl = os.environ.get('MAIL_USE_SSL') in [1, 'true']

  if tls:
    protocol = 'smtpTLS'
  elif ssl:
    protocol = 'smtps'
  else:
    protocol = 'smtp'

  username = os.environ.get('MAIL_USERNAME')
  password = os.environ.get('MAIL_PASSWORD')

  host = os.environ.get('MAIL_SERVER')
  port = os.environ.get('MAIL_PORT')

  if all([protocol, username, password, host, port]):
    mail_uri = f'{protocol}://{username}:{password}@{host}:{port}'
    default_domain_settings['mail_uri'] = mail_uri
    default_domain_settings['mail_from'] = mail_from
    if default_domain_id:
      session.execute(
        domains.update().where(domains.c.id==default_domain_id).values(settings=default_domain_settings)
      )

  session.commit()


def downgrade():
  pass
