"""add_folders

Revision ID: 7153563c6767
Revises: 8f85583969bb
Create Date: 2019-05-26 21:23:50.772408

"""

# revision identifiers, used by Alembic.
revision = '7153563c6767'
down_revision = '8f85583969bb'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('folders',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('domain_id', sa.Integer(), nullable=True),
    sa.Column('organization_id', sa.Integer(), nullable=True),
    sa.Column('tree_id', sa.Integer(), nullable=True),
    sa.Column('parent_id', sa.Integer(), nullable=True),
    sa.Column('lft', sa.Integer(), nullable=False),
    sa.Column('rgt', sa.Integer(), nullable=False),
    sa.Column('level', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['domain_id'], ['domains.id'], ),
    sa.ForeignKeyConstraint(['organization_id'], ['organizations.id'], ),
    sa.ForeignKeyConstraint(['parent_id'], ['folders.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sqlite_autoincrement=True
    )

    op.create_table('folder_users',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('folder_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['folder_id'], ['folders.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sqlite_autoincrement=True
    )

    op.add_column('cloud_streams', sa.Column('folder_id', sa.Integer(), nullable=True))
    op.create_foreign_key('cloud_streams_folder_fkey', 'cloud_streams', 'folders', ['folder_id'], ['id'], ondelete='SET NULL')
    

def downgrade():
    op.drop_constraint('cloud_streams_folder_fkey', 'cloud_streams', type_='foreignkey')
    op.drop_column('cloud_streams', 'folder_id')
    op.drop_table('folder_users')
    op.drop_table('folders')
