"""create table metrics

Revision ID: 8f85583969bb
Revises: f1ad71f16cd5
Create Date: 2019-06-10 15:12:54.108538

"""

# revision identifiers, used by Alembic.
revision = '8f85583969bb'
down_revision = 'f1ad71f16cd5'

import logging
from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm


logger = logging.getLogger(__name__)

def upgrade():
  op.create_table('metrics',
    sa.Column('date', sa.String(), nullable=False),
    sa.Column('api_requests', sa.Integer(), nullable=False, server_default="0"),
    sa.Column('source_loses', sa.Integer(), nullable=False, server_default="0"),
    sa.PrimaryKeyConstraint('date'),
    sqlite_autoincrement=True
  )

  rows = []
  if not rows:
    return

  rows.sort(key=lambda r: r[0])  # by date

  from watcher.models import Metric
  bind = op.get_bind()
  session = orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  metrics = meta.tables['metrics']
  session.execute(
    metrics.insert(),
    [dict(date=r[0], api_requests=r[1], source_loses=r[2]) for r in rows]
  )
  session.commit()


def downgrade():
  op.drop_table('metrics')
