"""add preset to organization

Revision ID: 398e49f54de9
Revises: c6827815d6df
Create Date: 2019-05-17 13:48:49.391141

"""

# revision identifiers, used by Alembic.
revision = '398e49f54de9'
down_revision = 'c6827815d6df'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('organization_presets',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('deleted_at', sa.DateTime(), nullable=True),
        sa.Column('domain_id', sa.Integer(), nullable=False),
        sa.Column('preset_id', sa.Integer(), nullable=False),
        sa.Column('organization_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['domain_id'], ['domains.id'], ),
        sa.ForeignKeyConstraint(['organization_id'], ['organizations.id'], ),
        sa.ForeignKeyConstraint(['preset_id'], ['presets.id'], ),
        sa.PrimaryKeyConstraint('id'),
        sqlite_autoincrement=True
    )

    op.create_index(op.f('idx_organization_presets'), 'organization_presets', ['domain_id', 'preset_id', 'organization_id'], unique=False)


def downgrade():
    op.drop_table('organization_presets')
