"""move cams under default domain

Revision ID: c6827815d6df
Revises: f98421fdb9c3
Create Date: 2019-06-03 12:36:36.543648

"""

# revision identifiers, used by Alembic.
revision = 'c6827815d6df'
down_revision = 'f98421fdb9c3'

from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm
from sqlalchemy.schema import MetaData


def upgrade():
    from watcher.models import Domain, CloudStream
    bind = op.get_bind()
    session = orm.Session(bind=bind)
    meta = MetaData()
    meta.reflect(bind=bind)

    domains = meta.tables['domains']
    cloud_streams = meta.tables['cloud_streams']

    default_domain = session.execute(domains.select().where(domains.c.is_default == True)).fetchone()
    default_domain = dict(default_domain)

    session.execute(cloud_streams.update()
      .where(cloud_streams.c.domain_id == None)
      .values(domain_id=default_domain.get('id'))
    )

    session.commit()


def downgrade():
    pass
