"""add preset to usage statistics

Revision ID: a9aec64ab203
Revises: b7cbdbbb67e6
Create Date: 2019-04-15 17:31:01.397095

"""

# revision identifiers, used by Alembic.
revision = 'a9aec64ab203'
down_revision = 'b7cbdbbb67e6'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy import orm

def upgrade():
  bind = op.get_bind()
  session = orm.Session(bind=bind)

  session.execute('TRUNCATE TABLE disk_usages')
  session.execute('TRUNCATE TABLE session_usages')
  session.execute('TRUNCATE TABLE stream_usages')

  op.add_column(u'disk_usages', sa.Column('preset_id', sa.Integer(), nullable=True))
  op.add_column(u'session_usages', sa.Column('preset_id', sa.Integer(), nullable=True))
  op.add_column(u'stream_usages', sa.Column('preset_id', sa.Integer(), nullable=True))

  op.create_index(op.f('ix_disk_usages_preset_id'), 'disk_usages', ['preset_id'], unique=False)
  op.create_index(op.f('ix_session_usages_preset_id'), 'session_usages', ['preset_id'], unique=False)

  op.drop_index(op.f('ix_stream_usages_source_id'), table_name='stream_usages')
  op.create_index(op.f('ix_stream_usages_source_id_preset_id'), 'stream_usages', ['source_id', 'preset_id'], unique=True)

  session.commit()


def downgrade():
  op.drop_index(op.f('ix_disk_usages_preset_id'), table_name='disk_usages')
  op.drop_index(op.f('ix_session_usages_preset_id'), table_name='session_usages')

  op.drop_index(op.f('ix_stream_usages_source_id_preset_id'), table_name='stream_usages')
  op.create_index(op.f('ix_stream_usages_source_id'), 'stream_usages', ['source_id'], unique=True)

  op.drop_column(u'disk_usages', 'preset_id')
  op.drop_column(u'session_usages', 'preset_id')
  op.drop_column(u'stream_usages', 'preset_id')
