"""add preset_cameras

Revision ID: b7cbdbbb67e6
Revises: 43e819895c31
Create Date: 2019-04-12 15:07:16.570725

"""

# revision identifiers, used by Alembic.
revision = 'b7cbdbbb67e6'
down_revision = '43e819895c31'

import logging
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy import orm
from watcher import logger
from watcher.models import Domain, Preset, PresetCamera, CloudStream
from sqlalchemy.schema import MetaData
from sqlalchemy.sql import select, and_

log = logging.getLogger(__name__)

def upgrade():
  bind = op.get_bind()
  session = orm.Session(bind=bind)

  op.create_table('preset_cameras',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('preset_id', sa.Integer(), nullable=False),
    sa.Column('camera_id', sa.Text(), nullable=False),
    sa.ForeignKeyConstraint(['preset_id'], ['presets.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sqlite_autoincrement=True
  )

  op.create_index(op.f('idx_preset_cameras'), 'preset_cameras', ['preset_id', 'camera_id'], unique=False)

  meta = MetaData()
  meta.reflect(bind=bind)

  domains = meta.tables['domains']
  presets = meta.tables['presets']
  cloud_streams = meta.tables['cloud_streams']
  preset_cameras = meta.tables['preset_cameras']

  default_domain_id, = session.execute(
    select([domains.c.id])
    .where(domains.c.is_default.is_(True))
    .limit(1)
  ).fetchone() or (None, )

  default_preset_id, = session.execute(
    select([presets.c.id])
    .where(and_(
      presets.c.is_default.is_(True),
      presets.c.domain_id == default_domain_id,
    ))
    .limit(1)
  ).fetchone() or (None, )

  camera_names = [name for (name,) in session.execute(select([cloud_streams.c.name]))]

  if camera_names:
    session.execute(preset_cameras.insert().values([
      {
        preset_cameras.c.preset_id: default_preset_id,
        preset_cameras.c.camera_id: name
      }
      for name in camera_names
    ]))

  session.commit()

def downgrade():
  op.drop_table('preset_cameras')
