"""add presets

Revision ID: 0c91c4a29242
Revises: b395091084ff
Create Date: 2019-04-10 13:27:43.406060

"""

# revision identifiers, used by Alembic.
revision = '0c91c4a29242'
down_revision = 'b395091084ff'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
  JSONType = sa.dialects.postgresql.JSON

  op.create_table('presets',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('domain_id', sa.Integer(), nullable=True),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('dvr_depth', sa.Integer(), nullable=True),
    sa.Column('dvr_space', sa.Integer(), nullable=True),
    sa.Column('vision_params', JSONType(), nullable=True),
    sa.Column('is_adjustable', sa.Boolean(), nullable=False, default=False),
    sa.Column('is_default', sa.Boolean(), nullable=False, default=False),
    sa.Column('is_deleted', sa.Boolean(), nullable=False, default=False),
    sa.ForeignKeyConstraint(['domain_id'], ['domains.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    sqlite_autoincrement=True
  )
  op.create_index(op.f('idx_adjustable_default'), 'presets', ['is_adjustable', 'is_default', 'domain_id'], unique=True)

def downgrade():
  op.drop_index(op.f('idx_adjustable_default'), table_name='presets')
  op.drop_table('presets')
