"""add_default_organization

Revision ID: b395091084ff
Revises: 87c10af2e41a
Create Date: 2019-04-19 11:20:17.563665

"""

# revision identifiers, used by Alembic.
revision = 'b395091084ff'
down_revision = '87c10af2e41a'

from alembic import op
import sqlalchemy as sa
import json
from sqlalchemy.dialects import postgresql
from sqlalchemy import orm
from sqlalchemy.orm.attributes import flag_modified
from sqlalchemy.schema import MetaData

def upgrade():
  bind = op.get_bind()
  session = orm.Session(bind=bind)
  from watcher.models import Domain, User, CloudStream, Organization

  meta = MetaData()
  meta.reflect(bind=bind)

  organizations = meta.tables['organizations']
  domains = meta.tables['domains']
  users = meta.tables['users']
  cloud_streams = meta.tables['cloud_streams']

  default_domain = session.execute(domains.select().where(domains.c.is_default==True)).fetchone()
  default_domain = dict(default_domain)
  
  domain_settings = default_domain['settings'] or {}

  organization = session.execute(organizations.select().where(organizations.c.domain_id==default_domain['id'])).fetchone()
  
  organization_id = None
  
  if organization:
    organization_id = organization.id
  else:
    organization = {
      'title': 'Cameras',
      'domain_id': default_domain['id'],
      'user_limit': 1000,
      'camera_limit': 1000,
      'dvr_limit': 100,
    }
    if default_domain['owner_id']:
      organization['owner_id'] = default_domain['owner_id']
      
    res = session.execute(organizations.insert().values(organization))
    organization_id = res.inserted_primary_key[0]
  
  
  domain_settings['default_organization_id'] = organization_id

  default_domain['settings'] = domain_settings

  session.execute(domains.update().where(domains.c.id == default_domain['id']).values(default_domain))

  session.execute(users.update().values(organization_id=organization_id))
  session.execute(cloud_streams.update().values(organization_id=organization_id))

  session.commit()


def downgrade():
    pass
