"""add_organizations

Revision ID: 87c10af2e41a
Revises: 590b24d4b14b
Create Date: 2019-04-19 09:59:48.857923

"""

# revision identifiers, used by Alembic.
revision = '87c10af2e41a'
down_revision = '590b24d4b14b'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql



def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('organizations',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('domain_id', sa.Integer(), nullable=True),
    sa.Column('owner_id', sa.Integer(), nullable=True),
    sa.Column('user_limit', sa.Integer(), nullable=True),
    sa.Column('camera_limit', sa.Integer(), nullable=True),
    sa.Column('dvr_limit', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['domain_id'], ['domains.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['owner_id'], ['users.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    sqlite_autoincrement=True
    )

    op.add_column('cloud_streams', sa.Column('domain_id', sa.Integer(), nullable=True))
    op.add_column('cloud_streams', sa.Column('organization_id', sa.Integer(), nullable=True))
    op.create_foreign_key('cloud_streams_domain_fkey', 'cloud_streams', 'domains', ['domain_id'], ['id'], ondelete='SET NULL')
    op.create_foreign_key('cloud_streams_organization_fkey', 'cloud_streams', 'organizations', ['organization_id'], ['id'], ondelete='SET NULL')
    op.add_column('users', sa.Column('organization_id', sa.Integer(), nullable=True))
    op.create_foreign_key('users_organization_fkey', 'users', 'organizations', ['organization_id'], ['id'], ondelete='SET NULL')




def downgrade():
    op.drop_constraint('users_organization_fkey', 'users', type_='foreignkey')
    op.drop_constraint('cloud_streams_organization_fkey', 'cloud_streams', type_='foreignkey')
    op.drop_constraint('cloud_streams_domain_fkey', 'cloud_streams', type_='foreignkey')
    op.drop_column('users', 'organization_id')
    op.drop_column('cloud_streams', 'organization_id')
    op.drop_column('cloud_streams', 'domain_id')

    op.drop_table('organizations')

