"""add_user_settings

Revision ID: 9a3cbe077362
Revises: 5fa9cb92a00d
Create Date: 2019-04-10 07:14:35.282090

"""

# revision identifiers, used by Alembic.
revision = '9a3cbe077362'
down_revision = '5fa9cb92a00d'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy import orm

def upgrade():
  JSONType = sa.dialects.postgresql.JSON

  op.add_column('users', sa.Column('locale', sa.String(length=5), nullable=True))
  op.add_column('users', sa.Column('name', sa.String(length=150), nullable=True))
  op.add_column('users', sa.Column('phone', sa.String(length=100), nullable=True))
  op.add_column('users', sa.Column('user_settings', JSONType(), nullable=True, default=None))

  bind = op.get_bind()
  session = orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  users = meta.tables['users']

  session.execute(
    users.update().values(user_settings={})
  )
  session.commit()


def downgrade():
  op.drop_column('users', 'user_settings')
  op.drop_column('users', 'phone')
  op.drop_column('users', 'name')
  op.drop_column('users', 'locale')