"""add_default_domain

Revision ID: 5fa9cb92a00d
Revises: 47a33d44a950
Create Date: 2019-03-25 21:33:56.885530

"""

# revision identifiers, used by Alembic.
revision = '5fa9cb92a00d'
down_revision = '47a33d44a950'

import random
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy import orm

def upgrade():
  from watcher.models import User

  bind = op.get_bind()
  session = orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  domains = meta.tables['domains']
  config = meta.tables['config']
  users = meta.tables['users']


  default_domain = session.execute(domains.select().where(domains.c.is_default.is_(True))).fetchone()

  if not default_domain:
    domain_title = "Flussonic Watcher"
    domain_settings = {}

    admin_id, = session.execute(
      sa.select([users.c.id]).where(
        sa.and_(users.c.is_admin.is_(True),
        users.c.is_active.is_(True))
      )
    ).fetchone() or (None, )

    for cfg in session.execute(config.select()):
      if cfg.grp == 'brand' and cfg.name == 'page_title' and cfg.value:
        domain_title = cfg.value
        continue

      domain_settings[f'{cfg.grp}_{cfg.name}'] = cfg.value
    
    q = (
      postgresql
      .insert(domains)
      .returning(domains.c.id)
      .values(
        is_default=True,
        settings=domain_settings,
        title=domain_title,
        domain_code=''.join(["%s" % random.randint(0, 9) for i in range(5)]),
        owner_id=admin_id,
      )
    )
    
    domain_id, = session.execute(q).fetchone()

    session.execute(
      users.update().values(domain_id=domain_id)
    )
    session.commit()


def downgrade():
    pass
