"""add_domains

Revision ID: 47a33d44a950
Revises: ee545b0518c2
Create Date: 2019-03-25 19:51:22.334172

"""

# revision identifiers, used by Alembic.
revision = '47a33d44a950'
down_revision = 'a1646f25e012'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
    JSONType = sa.dialects.postgresql.JSON

    op.create_table('domains',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('is_default', sa.Boolean(), nullable=False),
    sa.Column('owner_id', sa.Integer(), nullable=True),
    sa.Column('domain_code', sa.String(length=10), nullable=False),
    sa.Column('settings', JSONType(), nullable=True),
    sa.ForeignKeyConstraint(['owner_id'], ['users.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('domain_code'),
    sqlite_autoincrement=True
    )

    op.add_column(u'users', sa.Column('domain_id', sa.Integer(), nullable=True))
    op.create_foreign_key('users_domains_fkey', 'users', 'domains', ['domain_id'], ['id'], ondelete='SET NULL')
    
    op.create_unique_constraint('authorized_ip_domain_id_uc', 'users', ['authorized_ip', 'domain_id'])
    op.create_unique_constraint('email_domain_id_uc', 'users', ['email', 'domain_id'])
    op.create_unique_constraint('external_id_domain_id_uc', 'users', ['external_id', 'domain_id'])

    op.drop_index('ix_users_authorized_ip', table_name='users')
    op.create_index(op.f('ix_users_authorized_ip'), 'users', ['authorized_ip'], unique=False)
    op.drop_index('ix_users_email', table_name='users')
    op.create_index(op.f('ix_users_email'), 'users', ['email'], unique=False)
    op.drop_index('ix_users_external_id', table_name='users')
    op.create_index(op.f('ix_users_external_id'), 'users', ['external_id'], unique=False)

    # ### end Alembic commands ###




def downgrade():
    op.drop_index(op.f('ix_users_external_id'), table_name='users')
    op.create_index('ix_users_external_id', 'users', ['external_id'], unique=True)
    op.drop_index(op.f('ix_users_email'), table_name='users')
    op.create_index('ix_users_email', 'users', ['email'], unique=True)
    op.drop_index(op.f('ix_users_authorized_ip'), table_name='users')
    op.create_index('ix_users_authorized_ip', 'users', ['authorized_ip'], unique=True)
    op.drop_constraint('external_id_domain_id_uc', 'users', type_='unique')
    op.drop_constraint('email_domain_id_uc', 'users', type_='unique')
    op.drop_constraint('authorized_ip_domain_id_uc', 'users', type_='unique')
    
    op.drop_constraint('users_domains_fkey', 'users', type_='foreignkey')
    op.drop_column(u'users', 'domain_id')

    op.drop_table('domains')
    # ### end Alembic commands ###
